/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.diagramfilters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.emf.ecoretools.filters.diagramfilters.IDiagramFilter;
import org.eclipse.emf.ecoretools.filters.internal.utils.DiagramFilterUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiagramFilter
implements IDiagramFilter {
    private static String DIAGRAM_FILTER_PREFERENCE_STORE_KEY = "DiagramFilterPreferenceStoreKey";
    private Map<String, String> filteredType = new TreeMap<String, String>();

    public AbstractDiagramFilter() {
        this.initializeMap();
    }

    @Override
    public List<String> getCurrentFilteredTypeConfiguration() {
        return this.readFilteredTypes(this.getPreferenceStore());
    }

    @Override
    public Map<String, String> getFilteredTypeDescription() {
        return this.getFilteredTypeMap();
    }

    public Map<String, String> getFilteredTypeMap() {
        return this.filteredType;
    }

    public abstract Collection<IElementType> getIElementTypes();

    public abstract IPreferenceStore getPreferenceStore();

    protected void initializeMap() {
        for (IElementType object : this.getIElementTypes()) {
            IElementType elementType;
            String elementTypeHint;
            if (!(object instanceof IElementType) || (elementTypeHint = ((IHintedType)(elementType = object)).getSemanticHint()) == null || elementTypeHint.length() < 1) continue;
            String nameValue = String.valueOf(elementType.getDisplayName()) + " - " + elementTypeHint;
            this.filteredType.put(elementTypeHint, nameValue);
        }
    }

    protected List<String> readFilteredTypes(IPreferenceStore store) {
        String storedValue = store.getString(DIAGRAM_FILTER_PREFERENCE_STORE_KEY);
        if (storedValue == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(storedValue, DiagramFilterUtil.DIAGRAM_FILTER_STRING_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            result.add(stringTokenizer.nextToken());
        }
        return result;
    }

    @Override
    public void setCurrentFilteredTypeConfiguration(List<String> filteredTypes) {
        this.writeFilteredTypes(filteredTypes, this.getPreferenceStore());
    }

    protected void writeFilteredTypes(List<String> filteredTypes, IPreferenceStore store) {
        String storedValue = "";
        for (String currentType : filteredTypes) {
            storedValue = String.valueOf(storedValue) + DiagramFilterUtil.DIAGRAM_FILTER_STRING_DELIMITER + currentType;
        }
        store.setValue(DIAGRAM_FILTER_PREFERENCE_STORE_KEY, storedValue);
    }
}

