/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditor;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.ecoretools.diagram.part.INavigationListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class UpDiagramAction
extends WorkbenchPartAction
implements INavigationListener {
    public UpDiagramAction(IWorkbenchPart part) {
        super(part);
        EcoreDiagramEditor editor = (EcoreDiagramEditor)this.getWorkbenchPart();
        editor.getNavigationManager().addNavigationListener(this);
    }

    public void dispose() {
        EcoreDiagramEditor editor = (EcoreDiagramEditor)this.getWorkbenchPart();
        editor.getNavigationManager().removeNavigationListener(this);
        super.dispose();
    }

    @Override
    public void diagramChanged(Diagram newDiagram) {
        this.refresh();
    }

    protected boolean calculateEnabled() {
        return !this.getParentDiagrams().isEmpty();
    }

    protected void init() {
        this.setId("org.eclipse.emf.ecoretools.diagram.edit.actions.openParentDiagram");
        this.setText(Messages.UpDiagramAction_OpenParentAction);
    }

    public void run() {
        Diagram selectedDiagram;
        EcoreDiagramEditor editor = (EcoreDiagramEditor)this.getWorkbenchPart();
        List<Diagram> possibleDiagrams = this.getParentDiagrams();
        if (!possibleDiagrams.isEmpty() && (selectedDiagram = this.chooseDiagram(possibleDiagrams.toArray(new Diagram[possibleDiagrams.size()]))) != null) {
            editor.setDiagram(selectedDiagram);
        }
    }

    private List<Diagram> getParentDiagrams() {
        EcoreDiagramEditor editor = (EcoreDiagramEditor)this.getWorkbenchPart();
        ArrayList<Diagram> parentDiagrams = new ArrayList<Diagram>();
        Diagram activeDiagram = editor.getDiagram();
        if (activeDiagram != null) {
            EObject modelObject = activeDiagram.getElement();
            while (modelObject.eContainer() != null && parentDiagrams.isEmpty()) {
                EObject parentModelObject = modelObject.eContainer();
                for (EObject currentDiag : activeDiagram.eResource().getContents()) {
                    if (!(currentDiag instanceof Diagram) || !parentModelObject.equals(((Diagram)currentDiag).getElement())) continue;
                    parentDiagrams.add((Diagram)currentDiag);
                }
                modelObject = parentModelObject;
            }
        }
        return parentDiagrams;
    }

    private Diagram chooseDiagram(Diagram[] elements) {
        Diagram selectedDiagram = null;
        if (elements.length == 1) {
            selectedDiagram = elements[0];
        } else {
            Object[] selection;
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getWorkbenchPart().getSite().getShell(), (ILabelProvider)new AdapterFactoryLabelProvider(EcoreDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()));
            dialog.setMultipleSelection(false);
            dialog.setTitle(Messages.UpDiagramAction_DiagramSelection);
            dialog.setMessage(Messages.UpDiagramAction_SelectDiagram);
            dialog.setElements((Object[])elements);
            if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
                selectedDiagram = (Diagram)selection[0];
            }
        }
        return selectedDiagram;
    }
}

