/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.diagram.Messages;
import org.eclipse.emf.ecoretools.diagram.expressions.EcoreAbstractExpression;
import org.eclipse.emf.ecoretools.diagram.expressions.EcoreOCLFactory;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class EcoreVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.emf.ecoretools.diagram/debug/visualID";
    private static EcoreAbstractExpression EDataType_1004_Constraint;
    private static EcoreAbstractExpression EDataType_2004_Constraint;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("EcoreTools".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return EcoreVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                EcoreDiagramEditorPlugin.getInstance().logError(String.valueOf(Messages.EcoreVisualIDRegistry_UnableToParseView) + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElement.eClass()) && EcoreVisualIDRegistry.isDiagram((EPackage)domainElement)) {
            return 79;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = EcoreVisualIDRegistry.getModelID(containerView);
        if (!"EcoreTools".equals(containerModelID) && !"ecore".equals(containerModelID)) {
            return -1;
        }
        if ("EcoreTools".equals(containerModelID)) {
            containerVisualID = EcoreVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 5001: {
                if (!EcorePackage.eINSTANCE.getEAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 5002: {
                if (!EcorePackage.eINSTANCE.getEOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
            case 5003: {
                if (EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (EcorePackage.eINSTANCE.getEDataType().isSuperTypeOf(domainElement.eClass()) && EcoreVisualIDRegistry.isEDataType_2004((EDataType)domainElement)) {
                    return 2004;
                }
                if (!EcorePackage.eINSTANCE.getEEnum().isSuperTypeOf(domainElement.eClass())) break;
                return 2005;
            }
            case 5004: {
                if (!EcorePackage.eINSTANCE.getEAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 5005: {
                if (!EcorePackage.eINSTANCE.getEOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
            case 5006: {
                if (!EcorePackage.eINSTANCE.getEEnumLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 2006;
            }
            case 5007: {
                if (!EcorePackage.eINSTANCE.getEStringToStringMapEntry().isSuperTypeOf(domainElement.eClass())) break;
                return 2007;
            }
            case 5008: {
                if (!EcorePackage.eINSTANCE.getEEnumLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 2006;
            }
            case 79: {
                if (EcorePackage.eINSTANCE.getEClass().isSuperTypeOf(domainElement.eClass())) {
                    return 1001;
                }
                if (EcorePackage.eINSTANCE.getEPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 1002;
                }
                if (EcorePackage.eINSTANCE.getEAnnotation().isSuperTypeOf(domainElement.eClass())) {
                    return 1003;
                }
                if (EcorePackage.eINSTANCE.getEDataType().isSuperTypeOf(domainElement.eClass()) && EcoreVisualIDRegistry.isEDataType_1004((EDataType)domainElement)) {
                    return 1004;
                }
                if (!EcorePackage.eINSTANCE.getEEnum().isSuperTypeOf(domainElement.eClass())) break;
                return 1005;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = EcoreVisualIDRegistry.getModelID(containerView);
        if (!"EcoreTools".equals(containerModelID) && !"ecore".equals(containerModelID)) {
            return false;
        }
        if ("EcoreTools".equals(containerModelID)) {
            containerVisualID = EcoreVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1001: {
                if (4001 == nodeVisualID) {
                    return true;
                }
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 1002: {
                if (4006 == nodeVisualID) {
                    return true;
                }
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 1003: {
                if (4007 == nodeVisualID) {
                    return true;
                }
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 1004: {
                if (4008 == nodeVisualID) {
                    return true;
                }
                if (4009 != nodeVisualID) break;
                return true;
            }
            case 1005: {
                if (4010 == nodeVisualID) {
                    return true;
                }
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (4002 == nodeVisualID) {
                    return true;
                }
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (4003 == nodeVisualID) {
                    return true;
                }
                if (4004 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (4005 == nodeVisualID) {
                    return true;
                }
                if (5006 != nodeVisualID) break;
                return true;
            }
            case 5001: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 5002: {
                if (2002 != nodeVisualID) break;
                return true;
            }
            case 5003: {
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 != nodeVisualID) break;
                return true;
            }
            case 5004: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 5005: {
                if (2002 != nodeVisualID) break;
                return true;
            }
            case 5006: {
                if (2006 != nodeVisualID) break;
                return true;
            }
            case 5007: {
                if (2007 != nodeVisualID) break;
                return true;
            }
            case 5008: {
                if (2006 != nodeVisualID) break;
                return true;
            }
            case 79: {
                if (1001 == nodeVisualID) {
                    return true;
                }
                if (1002 == nodeVisualID) {
                    return true;
                }
                if (1003 == nodeVisualID) {
                    return true;
                }
                if (1004 == nodeVisualID) {
                    return true;
                }
                if (1005 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (4011 == nodeVisualID) {
                    return true;
                }
                if (4012 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (EcorePackage.eINSTANCE.getEReference().isSuperTypeOf(domainElement.eClass())) {
            return 3002;
        }
        return -1;
    }

    private static boolean isDiagram(EPackage element) {
        return true;
    }

    private static boolean isEDataType_1004(EDataType domainElement) {
        Object result;
        if (EDataType_1004_Constraint == null) {
            EDataType_1004_Constraint = EcoreOCLFactory.getExpression("not oclIsKindOf(ecore::EEnum)", (EClassifier)EcorePackage.eINSTANCE.getEDataType());
        }
        return (result = EDataType_1004_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isEDataType_2004(EDataType domainElement) {
        Object result;
        if (EDataType_2004_Constraint == null) {
            EDataType_2004_Constraint = EcoreOCLFactory.getExpression("not oclIsKindOf(ecore::EEnum)", (EClassifier)EcorePackage.eINSTANCE.getEDataType());
        }
        return (result = EDataType_2004_Constraint.evaluate(domainElement)) instanceof Boolean && (Boolean)result != false;
    }
}

