/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.providers.TabbedPropertiesLabelProvider;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.ChooseDialog;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractDetailedObjectPropertySection
extends AbstractTabbedPropertySection {
    private CLabel nameLabel;
    private Text text;
    private Button createButton;
    private Group groupDetails;
    private Composite detailsComposite;
    private SelectionListener createButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object[] availableTypes = AbstractDetailedObjectPropertySection.this.getAvailableTypes();
            Object selectedType = null;
            if (availableTypes.length == 1) {
                selectedType = availableTypes[0];
            } else if (availableTypes.length > 1) {
                ChooseDialog dialog = new ChooseDialog(Display.getDefault().getActiveShell(), AbstractDetailedObjectPropertySection.this.getAvailableTypes());
                dialog.setLabelProvider(AbstractDetailedObjectPropertySection.this.getLabelProvider());
                if (dialog.open() == 0 && dialog.getResult().length > 0) {
                    selectedType = dialog.getResult()[0];
                }
            }
            if (selectedType != null) {
                AbstractDetailedObjectPropertySection.this.createCommand(AbstractDetailedObjectPropertySection.this.getRelatedEObject(), selectedType);
                AbstractDetailedObjectPropertySection.this.updateGroupContents();
            }
        }
    };

    private Object[] getAvailableTypes() {
        Collection allTypes = this.getEditingDomain().getNewChildDescriptors((Object)this.getEObject(), null);
        ArrayList<EObject> availableTypes = new ArrayList<EObject>();
        for (Object currentType : allTypes) {
            if (!(currentType instanceof CommandParameter) || !this.getFeature().equals(((CommandParameter)currentType).getFeature())) continue;
            availableTypes.add(((CommandParameter)currentType).getEValue());
        }
        return availableTypes.toArray();
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    @Override
    protected void createWidgets(Composite composite) {
        this.nameLabel = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.text = this.getWidgetFactory().createText(composite, "", 8);
        this.createButton = this.getWidgetFactory().createButton(composite, Messages.AbstractDetailedObjectPropertySection_Create, 0);
        this.groupDetails = this.getWidgetFactory().createGroup(composite, Messages.AbstractDetailedObjectPropertySection_Details);
        this.groupDetails.setLayout((Layout)new GridLayout());
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.createButton, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.nameLabel, 5);
        data.right = new FormAttachment((Control)this.createButton, -5);
        data.top = new FormAttachment((Control)this.createButton, 0, 0x1000000);
        this.text.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this.createButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.nameLabel, 4);
        this.groupDetails.setLayoutData((Object)data);
    }

    public void refresh() {
        super.refresh();
        this.text.setText(this.updateConstraintText());
        this.updateGroupContents();
    }

    private String updateConstraintText() {
        String name = "";
        if (this.getRelatedEObject() != null && (name = this.getLabelProvider().getText((Object)this.getRelatedEObject())) == null) {
            name = "";
        }
        return name;
    }

    protected void updateGroupContents() {
        if (this.getRelatedEObject() != null) {
            if (this.detailsComposite != null && !this.detailsComposite.isDisposed()) {
                this.detailsComposite.dispose();
            }
            this.detailsComposite = this.getDetailsComposite();
            if (this.detailsComposite != null) {
                this.getWidgetFactory().adapt(this.detailsComposite);
            }
            this.groupDetails.getParent().layout();
            this.groupDetails.layout();
        }
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.createButton != null && !this.createButton.isDisposed()) {
            this.createButton.addSelectionListener(this.createButtonListener);
        }
    }

    @Override
    public void aboutToBeHidden() {
        if (this.createButton != null && !this.createButton.isDisposed()) {
            this.createButton.removeSelectionListener(this.createButtonListener);
        }
        super.aboutToBeHidden();
    }

    protected ILabelProvider getLabelProvider() {
        return new TabbedPropertiesLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());
    }

    public Group getGroupDetails() {
        return this.groupDetails;
    }

    protected abstract String getFeatureAsText();

    protected abstract EObject getRelatedEObject();

    protected abstract Composite getDetailsComposite();
}

