/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.ui.outline.decorator;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.ui.outline.decorator.IMarkerReader;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractValidationMarkerDecorator
implements ILightweightLabelDecorator {
    protected static final ImageDescriptor ERROR = Activator.getImageDescriptor("icons/ovr16/error_co.gif");
    protected static final ImageDescriptor WARNING = Activator.getImageDescriptor("icons/ovr16/warning_co.gif");
    private IResourceChangeListener resourceListener;
    private ListenerList listeners;
    private IMarkerReader markerReader;

    public void addListener(ILabelProviderListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)listener);
        if (this.resourceListener == null) {
            this.resourceListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    AbstractValidationMarkerDecorator.this.handleResourceChanged(event);
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
            if (this.listeners.isEmpty() && this.resourceListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
                this.resourceListener = null;
            }
        }
    }

    private void handleResourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(this.getMarkerReader().getMarkerType(), true);
        if (markerDeltas.length > 0) {
            if (Display.getCurrent() != Display.getDefault()) {
                this.asyncFireEObjectMarkerChanged();
            } else {
                this.fireEObjectMarkerChanged();
            }
        }
    }

    private void asyncFireEObjectMarkerChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractValidationMarkerDecorator.this.fireEObjectMarkerChanged();
            }
        });
    }

    private void fireEObjectMarkerChanged() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
            Object[] listenersArray = this.listeners.getListeners();
            int i = 0;
            while (i < listenersArray.length) {
                ((ILabelProviderListener)listenersArray[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resourceListener = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof EObject)) {
            return;
        }
        EObject object = (EObject)element;
        if (object.eResource() != null) {
            IStatus status = this.getMarkerReader().getStatus(object);
            if (status.matches(4)) {
                decoration.addOverlay(this.getErrorImageDescriptor());
            } else if (status.matches(2)) {
                decoration.addOverlay(this.getWarningImageDescriptor());
            }
        }
    }

    protected IMarkerReader getMarkerReader() {
        if (this.markerReader == null) {
            this.markerReader = this.createMarkerReader();
        }
        return this.markerReader;
    }

    protected abstract IMarkerReader createMarkerReader();

    protected ImageDescriptor getErrorImageDescriptor() {
        return ERROR;
    }

    protected ImageDescriptor getWarningImageDescriptor() {
        return WARNING;
    }
}

