/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.Messages;
import org.eclipse.emf.ecoretools.filters.internal.dialogs.FilterDiagramSelectionDialog;
import org.eclipse.emf.ecoretools.filters.internal.utils.DiagramFilterUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureFilterDiagramAction
extends Action {
    protected IGraphicalEditPart host;
    public static String ID = "configureFilterDiagramAction";

    public ConfigureFilterDiagramAction() {
        this.setId(ID);
        this.setImageDescriptor(FilterPlugin.getImageDescriptor("icons/etool16/configurefilter_exec.gif"));
        this.setText(Messages.ConfigureFilterDiagramAction_Configure);
        this.setToolTipText(Messages.ConfigureFilterDiagramAction_Configure_tooltip);
    }

    private List<String> buildSelection(Diagram diagram) {
        ArrayList<String> intinialSelection = new ArrayList<String>();
        List<String> savedConfiguration = DiagramFilterUtil.getCurrentFilteredTypeConfiguration(diagram);
        for (String key : DiagramFilterUtil.getDiagramFilteredTypeDescription(diagram).keySet()) {
            if (!DiagramFilterUtil.isInKey(key, savedConfiguration)) continue;
            intinialSelection.add(key);
        }
        return intinialSelection;
    }

    private void processResult(Diagram diagram, Object[] result) {
        ArrayList<String> filteredTypes = new ArrayList<String>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof String) {
                filteredTypes.add((String)object);
            }
            ++n2;
        }
        DiagramFilterUtil.setCurrentFilteredTypeConfiguration(diagram, filteredTypes);
    }

    public void run() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return;
        }
        this.host = ((DiagramEditor)editorPart).getDiagramEditPart();
        if (!(this.host instanceof IGraphicalEditPart)) {
            return;
        }
        View view = (View)this.host.getModel();
        if (view.getDiagram() == null) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getShell();
        FilterDiagramSelectionDialog dialog = new FilterDiagramSelectionDialog(shell, view.getDiagram());
        dialog.setInput(DiagramFilterUtil.getDiagramFilteredTypeDescription(view.getDiagram()));
        List<String> selection = this.buildSelection(view.getDiagram());
        dialog.setInitialElementSelections(selection);
        switch (dialog.open()) {
            case 1: {
                break;
            }
            case 0: {
                this.processResult(view.getDiagram(), dialog.getResult());
            }
        }
    }
}

