/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.ui.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.diagram.ui.outline.AbstractModelNavigator;
import org.eclipse.emf.ecoretools.diagram.ui.outline.actions.CollapseAllAction;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Activator;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Messages;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.OverviewComposite;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractDiagramsOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener,
IAdaptable {
    private boolean isDispatching = false;
    private IDiagramGraphicalViewer viewer;
    private AbstractModelNavigator navigator;
    private Composite overview;
    private SashForm sashComp;
    private IAction showTreeAction;
    private IAction showOverviewAction;
    private IAction showAllAction;
    private IAction linkWithEditorAction;
    private CollapseAllAction collapseAllAction;
    private CollapseAllHandler collapseAllHandler;
    private DiagramEditor editor;

    public AbstractDiagramsOutlinePage(DiagramEditor ed) {
        this.viewer = ed.getDiagramGraphicalViewer();
        this.editor = ed;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.navigator != null && !this.navigator.isDisposed()) {
            this.navigator.getTreeViewer().addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.navigator != null && !this.navigator.isDisposed()) {
            this.navigator.getTreeViewer().removeSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        return this.navigator.getTreeViewer().getSelection();
    }

    public void setSelection(ISelection selection) {
        this.navigator.getTreeViewer().setSelection(selection);
    }

    protected void hookListeners() {
        this.navigator.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AbstractDiagramsOutlinePage.this.linkWithEditorAction.isChecked()) {
                    if (AbstractDiagramsOutlinePage.this.isDispatching) {
                        return;
                    }
                    AbstractDiagramsOutlinePage.this.selectAssociatedPartsInEditor();
                }
            }
        });
        this.navigator.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractDiagramsOutlinePage.this.handleDoubleClickEvent();
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void handleDoubleClickEvent() {
        IStructuredSelection selection = (IStructuredSelection)this.navigator.getTreeViewer().getSelection();
        Object selectedObject = selection.getFirstElement();
        if (selectedObject != null && selectedObject instanceof Diagram && this.editor.getDiagram() != selectedObject) {
            if (SelectInDiagramHelper.activateDiagram((Diagram)((Diagram)selectedObject)) == null) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor(this.getEditorInput((Diagram)selectedObject), this.getEditorID());
                }
                catch (PartInitException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecoretools.diagram.ui.outline", Messages.AbstractDiagramsOutlinePage_CanNotOpenEditor));
                }
            }
        } else {
            boolean cfr_ignored_0 = AdapterFactoryEditingDomain.unwrap((Object)selectedObject) instanceof EObject;
        }
    }

    private IEditorInput getEditorInput(Diagram diagram) {
        URI parentUri = diagram.eResource().getURI();
        URI uri = parentUri.appendFragment(diagram.eResource().getURIFragment((EObject)diagram));
        return new URIEditorInput(uri);
    }

    protected void selectAssociatedPartsInEditor() {
        this.isDispatching = true;
        IStructuredSelection selection = (IStructuredSelection)this.navigator.getTreeViewer().getSelection();
        ArrayList<EditPart> editPartsToSelect = new ArrayList<EditPart>();
        for (Object selectedObject : selection.toList()) {
            if (!(AdapterFactoryEditingDomain.unwrap(selectedObject) instanceof EObject)) continue;
            List editPartsToFilter = this.editor.getDiagramGraphicalViewer().findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)((EObject)AdapterFactoryEditingDomain.unwrap(selectedObject))), EditPart.class);
            for (EditPart currentEP : editPartsToFilter) {
                if (currentEP instanceof ResizableCompartmentEditPart || currentEP instanceof LabelEditPart) continue;
                editPartsToSelect.add(currentEP);
            }
        }
        if (editPartsToSelect.size() > 0) {
            this.editor.getDiagramGraphicalViewer().setSelection((ISelection)new StructuredSelection(editPartsToSelect));
            this.viewer.reveal((EditPart)editPartsToSelect.get(editPartsToSelect.size() - 1));
        }
        this.isDispatching = false;
    }

    public void createControl(Composite parent) {
        this.sashComp = new SashForm(parent, 512);
        this.sashComp.setLayoutData((Object)new GridData(1808));
        RootEditPart rootEditPart = this.viewer.getRootEditPart();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            this.overview = this.createOverview((Composite)this.sashComp, (ScalableFreeformRootEditPart)rootEditPart);
            this.overview.setLayoutData((Object)new GridData(1808));
        }
        this.navigator = this.createNavigator((Composite)this.sashComp, this.getSite());
        this.sashComp.setWeights(new int[]{30, 70});
        this.getSite().setSelectionProvider((ISelectionProvider)this.navigator.getTreeViewer());
        this.createActions();
        this.hookListeners();
    }

    protected Composite createOverview(Composite parent, ScalableFreeformRootEditPart rootEditPart) {
        return new OverviewComposite(parent, rootEditPart);
    }

    protected void createActions() {
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.createSorterActions(tbm);
        tbm.add((IContributionItem)new Separator());
        this.createShowOutlineActions(tbm);
        this.fillDropDownMenu(this.getSite().getActionBars().getMenuManager());
    }

    private void createShowOutlineActions(IToolBarManager tbm) {
        final IPreferenceStore ps = this.getPreferenceStore();
        this.collapseAllAction = new CollapseAllAction(this.navigator.getTreeViewer());
        ImageDescriptor collapseAllIcon = Activator.getImageDescriptor("icons/elcl16/collapseall.gif");
        this.collapseAllAction.setImageDescriptor(collapseAllIcon);
        this.collapseAllAction.setHoverImageDescriptor(collapseAllIcon);
        tbm.add((IAction)this.collapseAllAction);
        this.collapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.navigator.getTreeViewer());
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        service.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseAllHandler);
        this.linkWithEditorAction = new Action(Messages.AbstractDiagramsOutlinePage_LinkWithEditor, 2){

            public void run() {
                if (AbstractDiagramsOutlinePage.this.linkWithEditorAction.isChecked()) {
                    if (AbstractDiagramsOutlinePage.this.isDispatching) {
                        return;
                    }
                    AbstractDiagramsOutlinePage.this.selectAssociatedPartsInEditor();
                }
            }
        };
        this.linkWithEditorAction.setToolTipText(this.linkWithEditorAction.getText());
        this.linkWithEditorAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools.diagram.ui.outline", (String)"icons/elcl16/synced.gif"));
        tbm.add(this.linkWithEditorAction);
        this.showTreeAction = new Action(Messages.AbstractDiagramsOutlinePage_ShowNavigator, 8){

            public void run() {
                if (AbstractDiagramsOutlinePage.this.navigator != null && !AbstractDiagramsOutlinePage.this.navigator.isDisposed()) {
                    AbstractDiagramsOutlinePage.this.performShowAction((Control)AbstractDiagramsOutlinePage.this.navigator, ps, 1);
                }
            }
        };
        this.showTreeAction.setToolTipText(this.showTreeAction.getText());
        this.showTreeAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools.diagram.ui.outline", (String)"icons/elcl16/tree_co.gif"));
        tbm.add(this.showTreeAction);
        this.showOverviewAction = new Action(Messages.AbstractDiagramsOutlinePage_ShowOverview, 8){

            public void run() {
                if (AbstractDiagramsOutlinePage.this.overview != null && !AbstractDiagramsOutlinePage.this.overview.isDisposed()) {
                    AbstractDiagramsOutlinePage.this.performShowAction((Control)AbstractDiagramsOutlinePage.this.overview, ps, 2);
                }
            }
        };
        this.showOverviewAction.setToolTipText(this.showOverviewAction.getText());
        this.showOverviewAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools.diagram.ui.outline", (String)"icons/elcl16/overview_co.gif"));
        tbm.add(this.showOverviewAction);
        this.showAllAction = new Action(Messages.AbstractDiagramsOutlinePage_ShowBoth, 8){

            public void run() {
                if (AbstractDiagramsOutlinePage.this.sashComp != null && !AbstractDiagramsOutlinePage.this.sashComp.isDisposed()) {
                    AbstractDiagramsOutlinePage.this.performShowAction(null, ps, 0);
                }
            }
        };
        this.showAllAction.setToolTipText(this.showAllAction.getText());
        this.showAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools.diagram.ui.outline", (String)"icons/elcl16/all_co.gif"));
        tbm.add(this.showAllAction);
        if (ps != null) {
            int showAction = 0;
            AbstractModelNavigator control = null;
            switch (showAction) {
                case 1: {
                    control = this.navigator;
                    this.showTreeAction.setChecked(true);
                    break;
                }
                case 2: {
                    control = this.overview;
                    this.showOverviewAction.setChecked(true);
                    break;
                }
                default: {
                    control = null;
                    this.showAllAction.setChecked(true);
                }
            }
            this.performShowAction((Control)control, ps, showAction);
        } else {
            this.showAllAction.setChecked(true);
            this.performShowAction(null, ps, 0);
        }
    }

    private void createSorterActions(IToolBarManager tbm) {
    }

    private void performShowAction(Control control, IPreferenceStore ps, int pref) {
        this.sashComp.setMaximizedControl(control);
    }

    private void fillDropDownMenu(IMenuManager menu) {
    }

    public Control getControl() {
        return this.sashComp;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EditingDomain.class) {
            return this.editor.getEditingDomain();
        }
        return null;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isDispatching) {
            return;
        }
        if (this.linkWithEditorAction.isChecked()) {
            ISelection selection = event.getSelection();
            this.syncSelection(selection);
        }
    }

    private void syncSelection(ISelection selection) {
        this.isDispatching = true;
        ArrayList<Object> newSelection = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : (IStructuredSelection)selection) {
                if (selectedObject instanceof GraphicalEditPart) {
                    newSelection.add(((GraphicalEditPart)selectedObject).resolveSemanticElement());
                    continue;
                }
                if (selectedObject instanceof ConnectionEditPart) {
                    newSelection.add(((ConnectionEditPart)selectedObject).resolveSemanticElement());
                    continue;
                }
                if (!(selectedObject instanceof EObject)) continue;
                newSelection.add(selectedObject);
            }
        }
        this.setSelection((ISelection)new StructuredSelection(newSelection));
        this.isDispatching = false;
    }

    public void dispose() {
        this.collapseAllHandler.dispose();
        this.unhookListeners();
        this.overview.dispose();
        this.navigator.dispose();
        super.dispose();
    }

    protected void unhookListeners() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected DiagramEditor getEditor() {
        return this.editor;
    }

    protected abstract AbstractModelNavigator createNavigator(Composite var1, IPageSite var2);

    protected abstract IPreferenceStore getPreferenceStore();

    protected abstract String getEditorID();
}

