/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EcoreBaseItemSemanticEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class EReferenceReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public EReferenceReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof EReference)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof EClass) || !(this.newEnd instanceof EClass)) {
            return false;
        }
        EClassifier target = this.getLink().getEType();
        return EcoreBaseItemSemanticEditPolicy.LinkConstraints.canExistEReference_3002(this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof EClassifier) || !(this.newEnd instanceof EClassifier)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof EClass)) {
            return false;
        }
        EClass source = (EClass)this.getLink().eContainer();
        return EcoreBaseItemSemanticEditPolicy.LinkConstraints.canExistEReference_3002(source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            if (this.getLink().getEOpposite() != null) {
                this.getLink().getEOpposite().setEOpposite(null);
            }
            this.getLink().setEOpposite(null);
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            if (this.getLink().getEOpposite() != null) {
                this.getLink().getEOpposite().setEOpposite(null);
            }
            this.getLink().setEOpposite(null);
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getEStructuralFeatures().remove((Object)this.getLink());
        this.getNewSource().getEStructuralFeatures().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setEType(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected EReference getLink() {
        return (EReference)this.getElementToEdit();
    }

    protected EClass getOldSource() {
        return (EClass)this.oldEnd;
    }

    protected EClass getNewSource() {
        return (EClass)this.newEnd;
    }

    protected EClassifier getOldTarget() {
        return (EClassifier)this.oldEnd;
    }

    protected EClassifier getNewTarget() {
        return (EClassifier)this.newEnd;
    }
}

