/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.ui.outline;

import org.eclipse.emf.ecoretools.diagram.ui.outline.AdditionalResources;
import org.eclipse.emf.ecoretools.diagram.ui.outline.internal.Messages;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class NavigatorLabelProvider
extends LabelProvider
implements IFontProvider {
    private Font boldFont = null;
    private ILabelProvider delegatedModelProvider;

    public NavigatorLabelProvider(ILabelProvider delegatedProvider) {
        this.delegatedModelProvider = delegatedProvider;
    }

    public Image getImage(Object element) {
        if (element instanceof Diagram) {
            Diagram diag = (Diagram)element;
            return this.getDiagramIcon(diag);
        }
        return this.delegatedModelProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof AdditionalResources) {
            return Messages.NavigatorLabelProvider_AdditionalResources;
        }
        if (element instanceof Diagram) {
            Diagram diag = (Diagram)element;
            return this.getDiagramText(diag);
        }
        return this.delegatedModelProvider.getText(element);
    }

    private String getDiagramText(Diagram d) {
        String name = d.getName();
        String id = d.getType();
        String diagramTypeName = Messages.NavigatorLabelProvider_DiagramDefaultName;
        if (id != null) {
            "".equals(id);
        }
        return name == null || name.length() == 0 ? diagramTypeName : String.valueOf(diagramTypeName) + " " + name;
    }

    private Image getDiagramIcon(Diagram d) {
        String id = d.getType();
        if (id != null) {
            "".equals(id);
        }
        return this.delegatedModelProvider.getImage((Object)d);
    }

    public Font getFont(Object element) {
        if (element instanceof Diagram) {
            if (this.boldFont == null) {
                Font originalFont = Display.getDefault().getSystemFont();
                FontData[] fontData = originalFont.getFontData();
                int i = 0;
                while (i < fontData.length) {
                    fontData[i].setStyle(fontData[i].getStyle() | 1);
                    ++i;
                }
                this.boldFont = new Font((Device)Display.getDefault(), fontData);
            }
            return this.boldFont;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
    }
}

