/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.ChangeBoundsDeferredRequest;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LostMessageEndEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;

public class LostMessageEndSelectionPolicy
extends AirResizableEditPolicy {
    private static List<Integer> handledAlignments = Lists.newArrayList();

    public LostMessageEndSelectionPolicy() {
        handledAlignments.add(1);
        handledAlignments.add(2);
        handledAlignments.add(4);
    }

    public void setHost(EditPart host) {
        Preconditions.checkArgument((boolean)(host instanceof LostMessageEndEditPart));
        super.setHost(host);
    }

    protected LostMessageEndEditPart getLostMessageEnd() {
        return (LostMessageEndEditPart)this.getHost();
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (handledAlignments.contains(request.getAlignment())) {
            result = super.getAlignCommand(request);
        }
        return result;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        this.cancelVerticalMoveDelta(request);
        return super.getMoveCommand(request);
    }

    protected Command getMoveDeferredCommand(ChangeBoundsDeferredRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.cancelVerticalMoveDelta(request);
        super.showChangeBoundsFeedback(request);
    }

    protected void cancelVerticalMoveDelta(ChangeBoundsRequest request) {
        Point moveDelta;
        if (request == null) {
            return;
        }
        RequestQuery query = new RequestQuery((Request)request);
        if (query.isMove() && (moveDelta = request.getMoveDelta().getCopy()) != null) {
            request.setMoveDelta(new Point(moveDelta.x, 0));
        }
    }
}

