/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;

public abstract class AbstractSequenceInteractionValidator {
    protected boolean valid = true;
    protected final RequestQuery request;
    protected Range expansionZone = Range.emptyRange();
    protected final Set<ISequenceEvent> eventInError = new HashSet<ISequenceEvent>();
    protected final Set<Integer> invalidPositions = new HashSet<Integer>();
    protected final Set<Range> invalidRanges = new HashSet<Range>();
    protected final Collection<ISequenceEvent> movedElements = new ArrayList<ISequenceEvent>();
    protected final Collection<Range> createdElements = new ArrayList<Range>();
    protected final Collection<Message> startReflexiveMessageToResize = new HashSet<Message>();
    protected final Collection<Message> endReflexiveMessageToResize = new HashSet<Message>();
    private boolean initialized;

    public AbstractSequenceInteractionValidator(RequestQuery request) {
        this.request = request;
    }

    public abstract SequenceDiagram getDiagram();

    public abstract Function<ISequenceEvent, Range> getRangeFunction();

    protected abstract void doValidation();

    public final boolean isValid() {
        this.validate();
        return this.valid;
    }

    public final void validate() {
        if (!this.initialized) {
            this.doValidation();
            this.initialized = true;
        }
    }

    public Collection<ISequenceEvent> getMovedElements() {
        return this.movedElements;
    }

    public Collection<Range> getCreatedElements() {
        return this.createdElements;
    }

    public Collection<Message> getResizedStartMessages() {
        return this.startReflexiveMessageToResize;
    }

    public Collection<Message> getResizedEndMessages() {
        return this.endReflexiveMessageToResize;
    }

    public Range getExpansionZone() {
        return this.expansionZone;
    }

    public Collection<ISequenceEvent> getEventsInError() {
        return this.eventInError;
    }

    public Collection<Integer> getInvalidPostions() {
        return this.invalidPositions;
    }

    public Collection<Range> getInvalidRanges() {
        return this.invalidRanges;
    }
}

