/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class DefaultViewpointResourceHandler
implements ViewpointResourceHandler {
    @Override
    public boolean handles(URI uri) {
        return uri != null && new FileQuery(uri.fileExtension()).isVSMFile();
    }

    @Override
    public Set<Viewpoint> collectViewpointDefinitions(Resource res) {
        HashSet viewpoints = Sets.newHashSet();
        for (Group group : Iterables.filter((Iterable)res.getContents(), Group.class)) {
            for (Viewpoint viewpoint : group.getOwnedViewpoints()) {
                viewpoints.add(viewpoint);
            }
        }
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)viewpoints, (Predicate)Predicates.notNull()));
    }
}

