/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ui;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.gef.ui.internal.tools.SelectConnectionEditPartTracker;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.MoveInDiagramDragTracker;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;

public class SiriusSelectConnectionEditPartTracker
extends SelectConnectionEditPartTracker
implements MoveInDiagramDragTracker {
    private boolean moveGroupActivated;
    private BendpointRequest bendpointRequest;
    private Point previousMouseLocation;

    public SiriusSelectConnectionEditPartTracker(ConnectionEditPart owner) {
        super(owner);
        this.setDisabledCursor(SharedCursors.NO);
    }

    protected Request createSourceRequest() {
        Request rq = super.createSourceRequest();
        if (rq instanceof BendpointRequest) {
            this.bendpointRequest = (BendpointRequest)rq;
        }
        return rq;
    }

    protected void updateSourceRequest() {
        super.updateSourceRequest();
        if (this.bendpointRequest != null) {
            if (this.moveGroupActivated) {
                this.bendpointRequest.getExtendedData().put("EDGE_MOVE_DELTA", this.computeDelta());
                this.bendpointRequest.getExtendedData().put("EDGE_GROUP_MOVE", Boolean.TRUE);
                this.bendpointRequest.getExtendedData().put("EDGE_GROUP_MOVE_HAS_BEEN_ACTIVATED_KEY", Boolean.TRUE);
            } else {
                this.bendpointRequest.getExtendedData().remove("EDGE_MOVE_DELTA");
                this.bendpointRequest.getExtendedData().put("EDGE_GROUP_MOVE", Boolean.FALSE);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        this.bendpointRequest = null;
    }

    private Dimension computeDelta() {
        Point newLocation = this.bendpointRequest.getLocation();
        Dimension diff = newLocation != null ? newLocation.getDifference(this.getStartLocation()) : this.getDragMoveDelta();
        return diff;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (0x100000C == e.keyCode) {
            this.moveGroupActivated = true;
            return true;
        }
        return super.handleKeyDown(e);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (0x100000C == e.keyCode) {
            this.moveGroupActivated = false;
            return true;
        }
        return super.handleKeyUp(e);
    }

    protected Cursor calculateCursor() {
        Command command;
        Cursor cursorToReturn = this.moveGroupActivated ? ((command = this.getCurrentCommand()) == null || !command.canExecute() ? this.getDisabledCursor() : SharedCursors.ARROW) : super.calculateCursor();
        return cursorToReturn;
    }

    protected boolean handleButtonDown(int button) {
        if (button == 2) {
            this.setCursor(SharedCursors.HAND);
            return this.stateTransition(1, 64);
        }
        return super.handleButtonDown(button);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        this.previousMouseLocation = this.getCurrentInput().getMouseLocation().getCopy();
        super.mouseDrag(me, viewer);
    }

    protected boolean handleDragStarted() {
        if (this.isInState(64)) {
            return this.stateTransition(64, 128);
        }
        return super.handleDragStarted();
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(128)) {
            if (this.getCurrentViewer().getControl() instanceof FigureCanvas) {
                FigureCanvas figureCanvas = (FigureCanvas)this.getCurrentViewer().getControl();
                Point currentMouseLocation = this.getCurrentInput().getMouseLocation();
                Dimension difference = this.previousMouseLocation.getDifference(currentMouseLocation);
                Point location = figureCanvas.getViewport().getViewLocation();
                figureCanvas.scrollTo(location.x + difference.width, location.y + difference.height);
            }
            return true;
        }
        return super.handleDragInProgress();
    }
}

