/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.graphicalcomponents.GraphicalRepresentationHandler;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationDescriptionItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointItemImpl;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SemanticElementSelectionWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SiriusRepresentationLabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class RepresentationSelectionWizardPage
extends WizardPage {
    private TreeViewer treeViewer;
    private final Session session;
    private Composite pageComposite;
    private RepresentationDescription representation;
    private Viewpoint viewpoint;
    private SemanticElementSelectionWizardPage semanticSelectionWizard;
    private RepresentationDescriptionItemImpl representationDescriptionItem;
    private EObject semanticElement;

    public RepresentationSelectionWizardPage(Session root) {
        super(Messages.RepresentationSelectionWizardPage_title);
        this.setTitle(Messages.RepresentationSelectionWizardPage_title);
        this.setMessage(Messages.RepresentationSelectionWizardPage_message);
        this.session = root;
    }

    public RepresentationSelectionWizardPage(Session theSession, RepresentationDescriptionItemImpl theRepresentationDescriptionItem) {
        this(theSession);
        this.representationDescriptionItem = theRepresentationDescriptionItem;
    }

    public RepresentationSelectionWizardPage(Session theSession, EObject theSemanticSelection) {
        this(theSession);
        this.semanticElement = theSemanticSelection;
    }

    public Viewpoint getViewpoint() {
        return this.viewpoint;
    }

    public boolean isPageComplete() {
        boolean result = false;
        ISelection selection = this.treeViewer.getSelection();
        if (this.semanticElement != null && selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof RepresentationDescriptionItemImpl) {
            RepresentationDescriptionItemImpl selectedRepresentationDescriptionItem = (RepresentationDescriptionItemImpl)((StructuredSelection)selection).getFirstElement();
            if (selectedRepresentationDescriptionItem.getWrappedObject() != null) {
                RepresentationDescription representationDescription = (RepresentationDescription)selectedRepresentationDescriptionItem.getWrappedObject();
                this.viewpoint = ((RepresentationDescriptionItemImpl)((StructuredSelection)selection).getFirstElement()).getViewpoint();
                this.representation = representationDescription;
                result = true;
            }
        } else if (this.semanticElement == null) {
            result = true;
        }
        return result;
    }

    public boolean canFlipToNextPage() {
        boolean result = false;
        this.setErrorMessage(null);
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof RepresentationDescriptionItemImpl) {
            RepresentationDescription representationDescription = (RepresentationDescription)((RepresentationDescriptionItemImpl)((StructuredSelection)selection).getFirstElement()).getWrappedObject();
            result = true;
            result = this.hasPermissionToCreateRepresentation(this.session, this.representation);
            if (result) {
                this.representation = representationDescription;
                this.viewpoint = ((RepresentationDescriptionItemImpl)((StructuredSelection)selection).getFirstElement()).getViewpoint();
            } else {
                this.setErrorMessage(Messages.RepresentationSelectionWizardPage_errorReadonlyContainer);
            }
        }
        return result;
    }

    private boolean hasPermissionToCreateRepresentation(Session theSession, RepresentationDescription theRepresentationDescription) {
        Collection containers;
        Optional<DRepresentationDescriptor> loadedInSessionDescriptor;
        boolean hasPermission = true;
        if (this.session instanceof DAnalysisSessionImpl && (loadedInSessionDescriptor = DialectManager.INSTANCE.getAllRepresentationDescriptors(this.session).stream().filter(rep -> EqualityHelper.areEquals((EObject)rep.getDescription(), (EObject)this.getRepresentation())).findFirst()).isPresent() && !(containers = ((DAnalysisSessionImpl)this.session).getAvailableRepresentationContainers(loadedInSessionDescriptor.get().getDescription())).isEmpty()) {
            hasPermission = false;
            for (DView container : containers) {
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)container);
                if (permissionAuthority != null && !permissionAuthority.canCreateIn((EObject)container)) continue;
                hasPermission = true;
                break;
            }
        }
        return hasPermission;
    }

    public RepresentationDescription getRepresentation() {
        return this.representation;
    }

    public void setSelectionWizard(SemanticElementSelectionWizardPage selectionWizard) {
        this.semanticSelectionWizard = selectionWizard;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        SessionContentProvider theContentProvider = new SessionContentProvider(this.semanticElement);
        GraphicalRepresentationHandler.GraphicalRepresentationHandlerBuilder graphicalRepresentationHandlerBuilder = new GraphicalRepresentationHandler.GraphicalRepresentationHandlerBuilder(this.session);
        GraphicalRepresentationHandler graphicalRepresentationHandler = graphicalRepresentationHandlerBuilder.customizeContentAndLabel(theContentProvider, (ILabelProvider)new SiriusRepresentationLabelProvider()).filterEmptyViewpoints().activateBrowserWithViewpointAndRepresentationDescriptionInformation().build();
        graphicalRepresentationHandler.createControl(this.pageComposite);
        this.treeViewer = graphicalRepresentationHandler.getTreeViewer();
        Collection<Viewpoint> availableViewpoints = ViewpointHelper.getAvailableViewpoints(this.session);
        ArrayList<ViewpointItemImpl> viewpointItemList = new ArrayList<ViewpointItemImpl>();
        for (Viewpoint availableViewpoint : availableViewpoints) {
            viewpointItemList.add(new ViewpointItemImpl(this.session, availableViewpoint, (Object)this));
        }
        graphicalRepresentationHandler.initInput();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepresentationSelectionWizardPage.this.setPageComplete(RepresentationSelectionWizardPage.this.isPageComplete());
                if (RepresentationSelectionWizardPage.this.semanticSelectionWizard != null) {
                    RepresentationSelectionWizardPage.this.semanticSelectionWizard.setRepresentation(RepresentationSelectionWizardPage.this.getRepresentation());
                    RepresentationSelectionWizardPage.this.semanticSelectionWizard.update();
                }
            }
        });
        if (this.representationDescriptionItem != null) {
            int itemCount = this.treeViewer.getTree().getItemCount();
            int i = 0;
            while (i < itemCount) {
                TreeItem[] subItems;
                TreeItem treeItem = this.treeViewer.getTree().getItem(i);
                TreeItem[] treeItemArray = subItems = treeItem.getItems();
                int n = subItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem subItem = treeItemArray[n2];
                    if (subItem.getData() instanceof RepresentationDescriptionItemImpl) {
                        RepresentationDescriptionItemImpl representationDescriptionItemTemp = (RepresentationDescriptionItemImpl)subItem.getData();
                        if (EqualityHelper.areEquals((EObject)((RepresentationDescription)this.representationDescriptionItem.getWrappedObject()), (EObject)((RepresentationDescription)representationDescriptionItemTemp.getWrappedObject()))) {
                            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)representationDescriptionItemTemp), true);
                            this.representation = (RepresentationDescription)representationDescriptionItemTemp.getWrappedObject();
                            this.viewpoint = representationDescriptionItemTemp.getViewpoint();
                            this.semanticSelectionWizard.setRepresentation(this.representation);
                            this.semanticSelectionWizard.update();
                        }
                    }
                    ++n2;
                }
                ++i;
            }
        }
        this.setControl((Control)this.pageComposite);
    }

    public boolean isCurrentPageOnWizard() {
        return super.isCurrentPage();
    }

    private static final class SessionContentProvider
    implements ITreeContentProvider {
        private static Object[] empty = new Object[0];
        private EObject semanticSelection;

        SessionContentProvider(EObject theSemanticSelection) {
            this.semanticSelection = theSemanticSelection;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = empty;
            if (parentElement instanceof ViewpointItemImpl) {
                if (this.semanticSelection != null) {
                    Collection subElement = ((ViewpointItem)parentElement).getChildren();
                    ArrayList<RepresentationDescriptionItem> filteredList = new ArrayList<RepresentationDescriptionItem>();
                    for (Object object : subElement) {
                        RepresentationDescriptionItem descriptionItem;
                        if (!(object instanceof RepresentationDescriptionItem) || !DialectManager.INSTANCE.canCreate(this.semanticSelection, (RepresentationDescription)(descriptionItem = (RepresentationDescriptionItem)object).getWrappedObject(), false)) continue;
                        filteredList.add(descriptionItem);
                    }
                    children = filteredList.toArray();
                } else {
                    children = ((ViewpointItemImpl)parentElement).getChildren().toArray();
                }
            }
            return children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList allChildren = Lists.newArrayList();
            if (inputElement instanceof Collection) {
                allChildren.addAll((Collection)inputElement);
            }
            return allChildren.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

