/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointResourceOperations {
    private final Resource resource;

    public ViewpointResourceOperations(Resource resource) {
        this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
    }

    public void unloadAndResetProxyURIs() {
        Map<EObject, URI> logicalURIs = this.computeLogicalURIs();
        this.resource.unload();
        for (InternalEObject obj : Iterables.filter(logicalURIs.keySet(), InternalEObject.class)) {
            if (!obj.eIsProxy()) continue;
            obj.eSetProxyURI(logicalURIs.get(obj));
        }
    }

    private Map<EObject, URI> computeLogicalURIs() {
        Preconditions.checkState((boolean)this.resource.isLoaded());
        HashMap logicalURIs = Maps.newHashMap();
        URI currentSiriusURI = null;
        TreeIterator allContents = EcoreUtil.getAllProperContents((Resource)this.resource, (boolean)false);
        while (allContents.hasNext()) {
            EObject internal = (EObject)allContents.next();
            if (internal instanceof Viewpoint) {
                currentSiriusURI = (URI)new ViewpointQuery((Viewpoint)internal).getViewpointURI().get();
            }
            if (currentSiriusURI == null) continue;
            String fragment = internal.eResource().getURIFragment(internal);
            logicalURIs.put(internal, currentSiriusURI.appendFragment(fragment));
        }
        return logicalURIs;
    }
}

