/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInteractionFrameValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;

public class InteractionUseMoveValidator
extends AbstractInteractionFrameValidator {
    public InteractionUseMoveValidator(InteractionUse interactionUse, RequestQuery requestQuery) {
        super((AbstractFrame)interactionUse, requestQuery);
        Preconditions.checkArgument((boolean)requestQuery.isMove());
        this.defaultFrameHeight = 50;
    }

    @Override
    protected Collection<ISequenceEvent> getFinalParents() {
        LinkedHashSet<ISequenceEvent> finalParents = new LinkedHashSet<ISequenceEvent>();
        Range insertionPoint = new Range(this.finalRange.getLowerBound(), this.finalRange.getLowerBound());
        Collection coveredLifelines = this.frame.computeCoveredLifelines();
        for (Lifeline lifeline : coveredLifelines) {
            EventFinder finder = new EventFinder(lifeline);
            finder.setEventsToIgnore(Predicates.in(Collections.singletonList(this.frame)));
            ISequenceEvent localParent = finder.findMostSpecificEvent(insertionPoint);
            if (localParent == null) continue;
            finalParents.add(localParent);
        }
        return finalParents;
    }

    @Override
    protected boolean canExpand() {
        return true;
    }

    @Override
    protected Range computeExpansionZone() {
        Range expansionZone = Range.emptyRange();
        RequestQuery requestQuery = this.getRequestQuery();
        if (requestQuery.isMove()) {
            expansionZone = this.finalRange;
        }
        return expansionZone;
    }
}

