/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.part;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.part.IDiagramDialectGraphicalViewer;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.SiriusPaletteToolDropTargetListener;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies.ChangeBoundRequestRecorder;
import org.eclipse.sirius.diagram.ui.tools.internal.part.SemanticElementToEditPartsMap;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;

public class SiriusDiagramGraphicalViewer
extends DiagramGraphicalViewer
implements IDiagramDialectGraphicalViewer {
    private static final int TOOLTIP_HIDE_DELAY = 10000;
    private ChangeBoundRequestRecorder recorder = new ChangeBoundRequestRecorder();
    private final SemanticElementToEditPartsMap elementToEditPartsMap = new SemanticElementToEditPartsMap();
    private Color backgroundColor;

    public ChangeBoundRequestRecorder getChangeBoundRequestRecorder() {
        return this.recorder;
    }

    @Override
    public void registerEditPartForSemanticElement(EObject element, EditPart ep) {
        this.elementToEditPartsMap.registerEditPartForElement(element, ep);
    }

    @Override
    public void unregisterEditPartForSemanticElement(EObject element, EditPart ep) {
        this.elementToEditPartsMap.unregisterEditPartForElement(element, ep);
    }

    @Override
    public void unregisterEditPart(EditPart ep) {
        this.elementToEditPartsMap.unregisterEditPart(ep);
    }

    @Override
    public <T extends EditPart> List<T> findEditPartsForElement(EObject element, Class<T> editPartClass) {
        return this.elementToEditPartsMap.findEditPartsForElement(element, editPartClass);
    }

    protected void handleDispose(DisposeEvent e) {
        super.handleDispose(e);
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
            this.backgroundColor = null;
        }
    }

    public void enableUpdates(boolean enable) {
        if (enable) {
            this.getLightweightSystemWithUpdateToggle().enableUpdates();
        } else {
            this.getLightweightSystemWithUpdateToggle().disableUpdates();
        }
    }

    public boolean areUpdatesDisabled() {
        return this.getLightweightSystemWithUpdateToggle().getToggleUpdateManager().shouldDisableUpdates();
    }

    private LightweightSystemWithUpdateToggle getLightweightSystemWithUpdateToggle() {
        return (LightweightSystemWithUpdateToggle)this.getLightweightSystem();
    }

    protected LightweightSystem createLightweightSystem() {
        LightweightSystemWithUpdateToggle lws = new LightweightSystemWithUpdateToggle();
        lws.setUpdateManager((UpdateManager)new ToggleUpdateManager());
        return lws;
    }

    public void addDropTargetListener(TransferDropTargetListener listener) {
        if (!(listener instanceof PaletteToolTransferDropTargetListener) || listener instanceof SiriusPaletteToolDropTargetListener) {
            super.addDropTargetListener(listener);
        }
    }

    public void setSelection(ISelection newSelection) {
        if (this.getContents() != null) {
            if (newSelection instanceof IStructuredSelection) {
                this.setFocus(null);
            }
            super.setSelection(newSelection);
        }
    }

    public EditPart findMouseEventTargetAt(Point location) {
        IFigure figure = this.getLightweightSystem().getRootFigure().findMouseEventTargetAt(location.x, location.y);
        EditPart part = null;
        while (part == null && figure != null) {
            part = (EditPart)this.getVisualPartMap().get(figure);
            figure = figure.getParent();
        }
        if (part == null) {
            return this.getContents();
        }
        return part;
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        DomainEventDispatcher eventDispatcher = this.getEventDispatcher();
        Method getToolTipHelperMethod = null;
        try {
            getToolTipHelperMethod = SWTEventDispatcher.class.getDeclaredMethod("getToolTipHelper", new Class[0]);
            getToolTipHelperMethod.setAccessible(true);
            ToolTipHelper toolTipHelper = (ToolTipHelper)getToolTipHelperMethod.invoke((Object)eventDispatcher, new Object[0]);
            toolTipHelper.setHideDelay(10000);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            SiriusPlugin.getDefault().error(Messages.SiriusDiagramGraphicalViewer_tooltipDisplayDelay, (Throwable)e);
        }
    }

    public void setBackgroundColor(Color color) {
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        this.backgroundColor = color;
    }

    private static class LightweightSystemWithUpdateToggle
    extends LightweightSystem {
        private LightweightSystemWithUpdateToggle() {
        }

        public ToggleUpdateManager getToggleUpdateManager() {
            return (ToggleUpdateManager)this.getUpdateManager();
        }

        public void disableUpdates() {
            this.getToggleUpdateManager().setDisableUpdates(true);
        }

        public void enableUpdates() {
            this.getToggleUpdateManager().setDisableUpdates(false);
        }
    }

    private static class ToggleUpdateManager
    extends DeferredUpdateManager {
        private boolean disableUpdates;
        private final Field invalidFiguresField = this.getAccessibleField("invalidFigures");
        private final Field validatingField = this.getAccessibleField("validating");

        ToggleUpdateManager() {
        }

        private Field getAccessibleField(String name) {
            try {
                Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (SecurityException e) {
                DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, name), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, name), (Throwable)e);
            }
            return null;
        }

        public boolean shouldDisableUpdates() {
            return this.disableUpdates;
        }

        protected void sendUpdateRequest() {
            EclipseUIUtil.displayAsyncExec((Runnable)new DeferredUpdateManager.UpdateRequest((DeferredUpdateManager)this));
        }

        public synchronized void setDisableUpdates(boolean disableUpdates) {
            boolean prevDisableUpdates = this.disableUpdates;
            this.disableUpdates = disableUpdates;
            if (!disableUpdates && prevDisableUpdates != disableUpdates) {
                this.sendUpdateRequest();
            }
        }

        public synchronized void performUpdate() {
            if (!this.shouldDisableUpdates()) {
                super.performUpdate();
            }
        }

        public void performValidation() {
            if (!this.shouldDisableUpdates()) {
                if (this.getInvalidFigures().isEmpty() || this.getValidating()) {
                    return;
                }
                try {
                    this.setValidating(true);
                    this.fireValidating();
                    int i = 0;
                    while (i < this.getInvalidFigures().size()) {
                        IFigure fig = (IFigure)this.getInvalidFigures().get(i);
                        fig.validate();
                        ++i;
                    }
                }
                finally {
                    this.getInvalidFigures().clear();
                    this.setValidating(false);
                }
            }
        }

        public List getInvalidFigures() {
            if (this.invalidFiguresField != null) {
                try {
                    return (List)this.invalidFiguresField.get((Object)this);
                }
                catch (IllegalArgumentException e) {
                    DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, this.invalidFiguresField.getName()), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, this.invalidFiguresField.getName()), (Throwable)e);
                }
            }
            return null;
        }

        public boolean getValidating() {
            if (this.validatingField != null) {
                try {
                    return this.validatingField.getBoolean((Object)this);
                }
                catch (IllegalArgumentException e) {
                    DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, this.validatingField.getName()), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, this.validatingField.getName()), (Throwable)e);
                }
            }
            return false;
        }

        public void setValidating(boolean validating) {
            if (this.validatingField != null) {
                try {
                    this.validatingField.setBoolean((Object)this, validating);
                }
                catch (IllegalArgumentException e) {
                    DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, this.validatingField.getName()), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.ToggleUpdateManager_fieldAccessError, this.validatingField.getName()), (Throwable)e);
                }
            }
        }

        public void queueWork() {
            if (!this.shouldDisableUpdates()) {
                super.queueWork();
            }
        }
    }
}

