/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.image;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.image.ImageManager;
import org.eclipse.sirius.business.api.image.ImageManagerProvider;

public class Base64ImageHelper {
    public static final String BASE64_IMAGE_PATTERN_WITH_SUBSTRINGS = "\"data:image/([a-zA-Z]{3,4});base64,(.*?)\"";
    private static final String BASE64_IMAGE_PATTERN = "\"data:image/[a-zA-Z]{3,4};base64,.*?\"";
    private static final String IMAGE_NAME_FORMAT = "yyyyMMdd_HHmmssSSS";

    public Map<Object, String> createFileAndUpdateAttribute(EObject eObject, EAttribute attr) {
        String strValue = (String)eObject.eGet((EStructuralFeature)attr);
        if (strValue != null) {
            Map<Object, String> createdFiles = this.createFiles(eObject, strValue);
            this.updateField(eObject, attr, strValue, createdFiles);
            return createdFiles;
        }
        return new HashMap<Object, String>();
    }

    private void updateField(EObject eObject, EAttribute attr, String strValue, Map<Object, String> createdFiles) {
        String newStringValue = strValue;
        for (String fileName : createdFiles.values()) {
            newStringValue = newStringValue.replaceFirst(BASE64_IMAGE_PATTERN, "\"" + fileName + "\"");
        }
        if (!Objects.equals(newStringValue, strValue)) {
            eObject.eSet((EStructuralFeature)attr, (Object)newStringValue);
        }
    }

    private Map<Object, String> createFiles(EObject notifier, String strValue) {
        Pattern pattern = Pattern.compile(BASE64_IMAGE_PATTERN_WITH_SUBSTRINGS);
        Matcher matcher = pattern.matcher(strValue);
        LinkedHashMap<Object, String> createdFiles = new LinkedHashMap<Object, String>();
        while (matcher.find()) {
            if (matcher.groupCount() != 2) continue;
            ImageManager imageManager = ImageManagerProvider.getImageManager();
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat(IMAGE_NAME_FORMAT);
            String strDate = formatter.format(date);
            String simpleImageName = String.valueOf(strDate) + "." + matcher.group(1);
            Map<Object, String> createFile = imageManager.createFile(notifier, simpleImageName, matcher.group(2));
            createdFiles.putAll(createFile);
        }
        return createdFiles;
    }
}

