/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.fx;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import org.eclipse.emf.ecp.view.model.internal.fx.AbstractControlRendererFX;
import org.eclipse.emf.ecp.view.model.internal.fx.Activator;
import org.eclipse.emf.ecp.view.model.internal.fx.GridCellFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFXFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emfforms.spi.common.report.ReportService;

public abstract class SimpleControlRendererFX
extends AbstractControlRendererFX {
    private GridDescriptionFX rendererGridDescription;
    private Label validationIcon;

    public SimpleControlRendererFX(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    @Override
    public final GridDescriptionFX getGridDescription() {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFXFactory.INSTANCE.createSimpleGrid(1, ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE ? 2 : 3, this);
        }
        return this.rendererGridDescription;
    }

    @Override
    protected final Node renderNode(GridCellFX gridCell) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int controlIndex = gridCell.getColumn();
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE) {
            ++controlIndex;
        }
        switch (controlIndex) {
            case 0: {
                return this.createLabel();
            }
            case 1: {
                this.validationIcon = (Label)this.createValidationIcon();
                return this.validationIcon;
            }
            case 2: {
                return this.createControl();
            }
        }
        throw new IllegalArgumentException(String.format("The provided GridCellFX (%1$s) cannot be used by this (%2$s) renderer.", ((Object)((Object)gridCell)).toString(), ((Object)((Object)this)).toString()));
    }

    @Override
    protected void applyValidation(VControl control, Node node) {
        super.applyValidation(control, node);
        if (control.getDiagnostic() == null) {
            this.validationIcon.setGraphic(null);
            return;
        }
        VDiagnostic diagnostic = control.getDiagnostic();
        switch (diagnostic.getHighestSeverity()) {
            case 4: {
                this.validationIcon.setGraphic((Node)new ImageView(Activator.getImage("icons/validation_error.png")));
                this.validationIcon.setTooltip(new Tooltip(diagnostic.getMessage()));
                break;
            }
            case 0: {
                this.validationIcon.setGraphic(null);
            }
        }
    }

    protected abstract Node createControl();
}

