/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore;

import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.group.model.VGroup;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;

public class GroupExpansionViewModelService
implements ViewModelService {
    private static final String STANDARD = "Standard";
    private static final String ADVANCED = "Advanced";
    private static final String ADVANCED_ANNOTATION = "Advanced (Use With Caution)";
    private static boolean isStandardGroupCollapsed;
    private static boolean isAdvancedGroupCollapsed;
    private static boolean isAdvancedAnnotationGroupCollapsed;
    private ModelChangeListener modelChangeListener;
    private ViewModelContext viewModelContext;

    static {
        isAdvancedGroupCollapsed = true;
        isAdvancedAnnotationGroupCollapsed = true;
    }

    public void instantiate(ViewModelContext context) {
        this.viewModelContext = context;
        VElement viewModel = context.getViewModel();
        VView view = null;
        if (!(viewModel instanceof VView)) {
            return;
        }
        view = (VView)viewModel;
        for (VContainedElement element : view.getChildren()) {
            if (!(element instanceof VGroup)) continue;
            VGroup group = (VGroup)element;
            if (STANDARD.equals(group.getName())) {
                group.setCollapsed(isStandardGroupCollapsed);
                continue;
            }
            if (ADVANCED.equals(group.getName())) {
                group.setCollapsed(isAdvancedGroupCollapsed);
                continue;
            }
            if (!ADVANCED_ANNOTATION.equals(group.getName())) continue;
            group.setCollapsed(isAdvancedAnnotationGroupCollapsed);
        }
        this.modelChangeListener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getNotifier() instanceof VGroup) {
                    VGroup group = (VGroup)notification.getNotifier();
                    if (GroupExpansionViewModelService.STANDARD.equals(group.getName())) {
                        isStandardGroupCollapsed = group.isCollapsed();
                    } else if (GroupExpansionViewModelService.ADVANCED.equals(group.getName())) {
                        isAdvancedGroupCollapsed = group.isCollapsed();
                    } else if (GroupExpansionViewModelService.ADVANCED_ANNOTATION.equals(group.getName())) {
                        isAdvancedAnnotationGroupCollapsed = group.isCollapsed();
                    }
                }
            }
        };
        context.registerViewChangeListener(this.modelChangeListener);
    }

    public void dispose() {
        this.viewModelContext.unregisterViewChangeListener(this.modelChangeListener);
    }

    public int getPriority() {
        return 0;
    }
}

