/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.swt.services.ECPSelectionProviderService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class DefaultSelectionProviderService
implements ECPSelectionProviderService {
    private final Map<VElement, ISelectionProvider> registeredProviders = new HashMap<VElement, ISelectionProvider>();
    private ViewModelContext context;
    private DelegatingSelectionProvider selectionProvider;
    private ModelChangeAddRemoveListener viewListener;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.selectionProvider = new DelegatingSelectionProvider();
        this.viewListener = this.createViewListener();
        context.registerViewChangeListener((ModelChangeListener)this.viewListener);
    }

    public void dispose() {
        this.registeredProviders.clear();
        this.selectionProvider = null;
        if (this.context != null) {
            this.context.unregisterViewChangeListener((ModelChangeListener)this.viewListener);
            this.viewListener = null;
            this.context = null;
        }
    }

    public int getPriority() {
        return 0;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public void registerSelectionProvider(VElement element, ISelectionProvider selectionProvider) {
        if (this.registeredProviders.put(Objects.requireNonNull(element), Objects.requireNonNull(selectionProvider)) != selectionProvider) {
            this.update();
        }
    }

    private void update() {
        ISelectionProvider delegate = null;
        TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(this.context.getViewModel()));
        while (delegate == null && iter.hasNext()) {
            delegate = this.registeredProviders.get(iter.next());
        }
        this.selectionProvider.setDelegate(delegate);
    }

    private ModelChangeAddRemoveListener createViewListener() {
        return new ModelChangeAddRemoveListener(){

            public void notifyRemove(Notifier notifier) {
                if (DefaultSelectionProviderService.this.registeredProviders.remove(notifier) != null) {
                    DefaultSelectionProviderService.this.update();
                }
            }

            public void notifyAdd(Notifier notifier) {
            }

            public void notifyChange(ModelChangeNotification notification) {
            }
        };
    }

    private static class DelegatingSelectionProvider
    implements ISelectionProvider {
        private ISelectionProvider delegate;
        private final ISelectionChangedListener delegateListener = this::selectionChanged;
        private final ListenerList<ISelectionChangedListener> listeners = new ListenerList();

        DelegatingSelectionProvider() {
        }

        public ISelection getSelection() {
            return this.delegate == null ? StructuredSelection.EMPTY : this.delegate.getSelection();
        }

        public void setSelection(ISelection selection) {
            if (this.delegate != null) {
                this.delegate.setSelection(selection);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        void setDelegate(ISelectionProvider delegate) {
            if (delegate == this.delegate) {
                return;
            }
            if (this.delegate != null) {
                this.delegate.removeSelectionChangedListener(this.delegateListener);
            }
            this.delegate = delegate;
            if (this.delegate != null) {
                this.delegate.addSelectionChangedListener(this.delegateListener);
                this.fireSelection(delegate.getSelection());
            }
        }

        void selectionChanged(SelectionChangedEvent event) {
            this.fireSelection(event.getSelection());
        }

        private void fireSelection(ISelection selection) {
            if (!this.listeners.isEmpty()) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
                this.listeners.forEach(l -> l.selectionChanged(event));
            }
        }
    }
}

