/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPFilterableCell;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.GridViewerColumnBuilder;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.menu.GridColumnAction;
import org.eclipse.emf.ecp.view.spi.table.nebula.grid.messages.Messages;
import org.eclipse.emfforms.common.Feature;
import org.eclipse.emfforms.common.Property;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerComparator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.jface.gridviewer.GridColumnLayout;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.jface.gridviewer.GridViewerRow;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class GridTableViewerComposite
extends AbstractTableViewerComposite<GridTableViewer> {
    private static final Map<Feature, Function<GridTableViewerComposite, ? extends IMenuListener>> FEATURE_MENU_LISTENERS = new HashMap<Feature, Function<GridTableViewerComposite, ? extends IMenuListener>>();
    private static final Map<Feature, Function<GridTableViewerComposite, ? extends ViewerFilter>> FEATURE_VIEWER_FILTERS = new HashMap<Feature, Function<GridTableViewerComposite, ? extends ViewerFilter>>();
    private GridTableViewer gridTableViewer;
    private Point lastKnownPointer;
    private final IObservableValue<Feature> activeFilteringMode = new WritableValue();

    static {
        FEATURE_MENU_LISTENERS.put(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW, comp -> {
            GridTableViewerComposite gridTableViewerComposite = comp;
            ((Object)((Object)gridTableViewerComposite)).getClass();
            return gridTableViewerComposite.new ColumnHideShowMenuListener();
        });
        FEATURE_MENU_LISTENERS.put(TableConfiguration.FEATURE_COLUMN_FILTER, comp -> {
            GridTableViewerComposite gridTableViewerComposite = comp;
            ((Object)((Object)gridTableViewerComposite)).getClass();
            return gridTableViewerComposite.new ColumnFilterMenuListener(ColumnConfiguration.FEATURE_COLUMN_FILTER, Messages.GridTableViewerComposite_toggleFilterControlsAction);
        });
        FEATURE_MENU_LISTENERS.put(TableConfiguration.FEATURE_COLUMN_REGEX_FILTER, comp -> {
            GridTableViewerComposite gridTableViewerComposite = comp;
            ((Object)((Object)gridTableViewerComposite)).getClass();
            return gridTableViewerComposite.new ColumnFilterMenuListener(ColumnConfiguration.FEATURE_COLUMN_REGEX_FILTER, Messages.GridTableViewerComposite_toggleRegexFilterControlsAction);
        });
        FEATURE_VIEWER_FILTERS.put(TableConfiguration.FEATURE_COLUMN_FILTER, comp -> (GridTableViewerComposite)((Object)comp).new GridColumnFilterViewerFilter());
        FEATURE_VIEWER_FILTERS.put(TableConfiguration.FEATURE_COLUMN_REGEX_FILTER, comp -> (GridTableViewerComposite)((Object)comp).new GridColumnRegexFilterViewerFilter());
    }

    public GridTableViewerComposite(Composite parent, int style, Object inputObject, TableViewerSWTCustomization customization, IObservableValue title, IObservableValue tooltip) {
        super(parent, style, inputObject, customization, title, tooltip);
        this.activeFilteringMode.addValueChangeListener(this::handleFilteringMode);
    }

    public void dispose() {
        this.activeFilteringMode.dispose();
        super.dispose();
    }

    public GridTableViewer getTableViewer() {
        return this.gridTableViewer;
    }

    protected GridTableViewer createTableViewer(TableViewerSWTCustomization<GridTableViewer> customization, Composite viewerComposite) {
        this.gridTableViewer = (GridTableViewer)customization.createTableViewer(viewerComposite);
        this.gridTableViewer.getControl().addMouseMoveListener(event -> {
            Point point = this.lastKnownPointer = new Point(event.x, event.y);
        });
        this.gridTableViewer.getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent event) {
                GridTableViewerComposite.this.lastKnownPointer = null;
            }
        });
        return this.gridTableViewer;
    }

    protected void configureContextMenu(GridTableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        this.mapFeatures(FEATURE_MENU_LISTENERS::get, iMenuListener -> menuMgr.addMenuListener(iMenuListener));
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
    }

    private <T> void mapFeatures(Function<Feature, Function<? super GridTableViewerComposite, T>> mapper, Consumer<? super T> action) {
        this.getEnabledFeatures().stream().map(mapper).filter(Objects::nonNull).map(f -> f.apply(this)).forEach(action);
    }

    protected void configureViewerFilters(GridTableViewer tableViewer) {
        this.mapFeatures(FEATURE_VIEWER_FILTERS::get, viewerFilter -> tableViewer.addFilter(viewerFilter));
    }

    protected AbstractColumnLayout createLayout(Composite viewerComposite) {
        GridColumnLayout layout = new GridColumnLayout();
        viewerComposite.setLayout((Layout)layout);
        return layout;
    }

    public Widget[] getColumns() {
        return this.gridTableViewer.getGrid().getColumns();
    }

    public void addColumnListener(ControlListener columnlistener) {
        int i = 0;
        while (i < this.gridTableViewer.getGrid().getColumns().length) {
            GridColumn gridColumn = this.gridTableViewer.getGrid().getColumns()[i];
            gridColumn.addControlListener(columnlistener);
            ++i;
        }
    }

    public TableControl getTableControl() {
        return new TableControl(){

            public boolean isDisposed() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().isDisposed();
            }

            public int getItemHeight() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getItemHeight();
            }

            public boolean getHeaderVisible() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getHeaderVisible();
            }

            public int getHeaderHeight() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getHeaderHeight();
            }

            public int getItemCount() {
                return GridTableViewerComposite.this.getTableViewer().getGrid().getItemCount();
            }
        };
    }

    protected ViewerColumn createColumn(ColumnConfiguration config, EMFDataBindingContext emfDataBindingContext, GridTableViewer tableViewer) {
        GridViewerColumn column = (GridViewerColumn)new GridViewerColumnBuilder(config).withDatabinding(emfDataBindingContext).build((AbstractTableViewer)tableViewer);
        return column;
    }

    public void setComparator(final TableViewerComparator comparator, final List<Integer> sortableColumns) {
        int i = 0;
        while (i < this.getTableViewer().getGrid().getColumns().length) {
            if (sortableColumns.contains(i)) {
                final int j = i;
                final GridColumn tableColumn = this.getTableViewer().getGrid().getColumns()[i];
                SelectionAdapter selectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Iterator iterator = sortableColumns.iterator();
                        while (iterator.hasNext()) {
                            int index = (Integer)iterator.next();
                            GridColumn column = GridTableViewerComposite.this.getTableViewer().getGrid().getColumns()[index];
                            if (index == j || column.getSort() == 0) continue;
                            column.setSort(0);
                        }
                        comparator.setColumn(j);
                        tableColumn.setSort(comparator.getDirection());
                        GridTableViewerComposite.this.gridTableViewer.refresh();
                    }
                };
                tableColumn.addSelectionListener((SelectionListener)selectionAdapter);
            }
            ++i;
        }
    }

    private GridColumn getCurrentColumn() {
        GridColumn result = null;
        Grid grid = this.getTableViewer().getGrid();
        if (this.lastKnownPointer == null) {
            Point[] selectedCells = grid.getCellSelection();
            if (selectedCells != null && selectedCells.length > 0) {
                result = grid.getColumn(selectedCells[0].x);
            }
        } else {
            result = grid.getColumn(this.lastKnownPointer);
        }
        return result;
    }

    private ColumnConfiguration getCurrentColumnConfig() {
        GridColumn column = this.getCurrentColumn();
        if (column == null) {
            return null;
        }
        return this.getColumnConfiguration((Widget)column);
    }

    public Feature getFilteringMode() {
        return this.activeFilteringMode == null ? null : (Feature)this.activeFilteringMode.getValue();
    }

    public void setFilteringMode(Feature filteringFeature) {
        if (this.activeFilteringMode == null) {
            throw new IllegalStateException();
        }
        if (filteringFeature != null && !this.getEnabledFeatures().contains(filteringFeature)) {
            throw new IllegalArgumentException(filteringFeature.toString());
        }
        this.activeFilteringMode.setValue((Object)filteringFeature);
    }

    private void handleFilteringMode(ValueChangeEvent<? extends Feature> event) {
        Boolean showFilterControl = this.getFilteringMode() != null;
        boolean recalculateHeader = false;
        Widget[] widgetArray = this.getColumns();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            Property showProperty = this.getColumnConfiguration(widget).showFilterControl();
            if (!showFilterControl.equals(showProperty.getValue())) {
                recalculateHeader = true;
                showProperty.setValue((Object)showFilterControl);
            }
            ++n2;
        }
        if (recalculateHeader) {
            this.getTableViewer().getGrid().recalculateHeader();
        }
    }

    static /* synthetic */ GridColumn access$5(GridTableViewerComposite gridTableViewerComposite) {
        return gridTableViewerComposite.getCurrentColumn();
    }

    private abstract class AbstractGridColumnFilterViewerFilter
    extends ViewerFilter {
        private final Feature feature;
        private final GridTableViewer tableViewer;
        private final Grid grid;

        AbstractGridColumnFilterViewerFilter(Feature feature) {
            this.feature = feature;
            this.tableViewer = GridTableViewerComposite.this.getTableViewer();
            this.grid = this.tableViewer.getGrid();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.isApplicable(viewer)) {
                return true;
            }
            GridItem dummyItem = null;
            GridViewerRow viewerRow = null;
            try {
                Widget[] widgetArray = GridTableViewerComposite.this.getColumns();
                int n = widgetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Widget widget = widgetArray[n2];
                    ColumnConfiguration config = GridTableViewerComposite.this.getColumnConfiguration(widget);
                    Object filter = config.matchFilter().getValue();
                    if (filter != null && !String.valueOf(filter).isEmpty()) {
                        GridColumn column = (GridColumn)widget;
                        int columnIndex = this.tableViewer.getGrid().indexOf(column);
                        CellLabelProvider labelProvider = this.tableViewer.getLabelProvider(columnIndex);
                        ECPFilterableCell filterable = (ECPFilterableCell)Adapters.adapt((Object)labelProvider, ECPFilterableCell.class);
                        if (filterable != null) {
                            String text = filterable.getFilterableText(element);
                            if (!this.matchesColumnFilter(text, filter)) {
                                return false;
                            }
                        } else {
                            if (dummyItem == null) {
                                this.grid.setRedraw(false);
                                dummyItem = new GridItem(this.grid, 0);
                                dummyItem.setData(element);
                                viewerRow = (GridViewerRow)((GridControlSWTRenderer.CustomGridTableViewer)this.tableViewer).getViewerRowFromItem((Widget)dummyItem);
                            }
                            ViewerCell cell = viewerRow.getCell(columnIndex);
                            labelProvider.update(cell);
                            if (!this.matchesColumnFilter(cell.getText(), filter)) {
                                return false;
                            }
                        }
                    }
                    ++n2;
                }
            }
            finally {
                if (dummyItem != null) {
                    dummyItem.dispose();
                    this.grid.setRedraw(true);
                }
            }
            return true;
        }

        protected boolean isApplicable(Viewer viewer) {
            return GridTableViewerComposite.this.getFilteringMode() == this.feature;
        }

        protected abstract boolean matchesColumnFilter(Object var1, Object var2);
    }

    private class ColumnFilterMenuListener
    implements IMenuListener2 {
        private final IValueChangeListener<Feature> radioListener = this::handleRadio;
        private final Feature feature;
        private final String label;
        private GridColumnAction action;

        ColumnFilterMenuListener(Feature feature, String label) {
            this.feature = feature;
            this.label = label;
        }

        public void menuAboutToShow(IMenuManager manager) {
            ColumnConfiguration columnConfiguration = GridTableViewerComposite.this.getCurrentColumnConfig();
            if (columnConfiguration == null) {
                return;
            }
            this.action = this.createAction(this.feature, this.label, columnConfiguration);
            this.action.setChecked(GridTableViewerComposite.this.getFilteringMode() == this.feature);
            manager.add((IAction)this.action);
            GridTableViewerComposite.this.activeFilteringMode.addValueChangeListener(this.radioListener);
        }

        public void menuAboutToHide(IMenuManager manager) {
            GridTableViewerComposite.this.activeFilteringMode.removeValueChangeListener(this.radioListener);
            this.action = null;
        }

        GridColumnAction createAction(final Feature feature, String label, ColumnConfiguration columnConfiguration) {
            return new FeatureBasedColumnAction(GridTableViewerComposite.this, GridTableViewerComposite.this, label, 8, feature){

                public void run() {
                    if (GridTableViewerComposite.this.getFilteringMode() == feature) {
                        GridTableViewerComposite.this.setFilteringMode(null);
                    } else {
                        GridTableViewerComposite.this.setFilteringMode(feature);
                    }
                }
            };
        }

        void handleRadio(ValueChangeEvent<? extends Feature> event) {
            this.action.setChecked(event.getObservableValue().getValue() == this.feature);
        }
    }

    private class ColumnHideShowMenuListener
    implements IMenuListener {
        private ColumnHideShowMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            final ColumnConfiguration columnConfiguration = GridTableViewerComposite.this.getCurrentColumnConfig();
            if (columnConfiguration == null) {
                return;
            }
            manager.add((IAction)new FeatureBasedColumnAction(GridTableViewerComposite.this, GridTableViewerComposite.this, Messages.GridTableViewerComposite_hideColumnAction, ColumnConfiguration.FEATURE_COLUMN_HIDE_SHOW){

                public void run() {
                    columnConfiguration.visible().setValue((Object)Boolean.FALSE);
                }
            });
            manager.add((IAction)new FeatureBasedColumnAction(GridTableViewerComposite.this, GridTableViewerComposite.this, Messages.GridTableViewerComposite_showAllColumnsAction, ColumnConfiguration.FEATURE_COLUMN_HIDE_SHOW){

                public void run() {
                    Widget[] widgetArray = GridTableViewerComposite.this.getColumns();
                    int n = widgetArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Widget widget = widgetArray[n2];
                        this.getGridTableViewer().getColumnConfiguration(widget).visible().setValue((Object)Boolean.TRUE);
                        ++n2;
                    }
                }

                @Override
                public boolean isEnabled() {
                    return super.isEnabled() && this.hasHiddenColumns();
                }

                boolean hasHiddenColumns() {
                    Widget[] widgetArray = GridTableViewerComposite.this.getColumns();
                    int n = widgetArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Widget widget = widgetArray[n2];
                        if (!((Boolean)this.getGridTableViewer().getColumnConfiguration(widget).visible().getValue()).booleanValue()) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            });
        }
    }

    private abstract class FeatureBasedColumnAction
    extends GridColumnAction {
        private final Feature feature;

        FeatureBasedColumnAction(GridTableViewerComposite gridTableViewerComposite2, String actionLabel, Feature feature) {
            super(gridTableViewerComposite2, actionLabel);
            this.setCurrentColumnProvider(() -> GridTableViewerComposite.access$5(GridTableViewerComposite.this));
            this.feature = feature;
        }

        FeatureBasedColumnAction(GridTableViewerComposite gridTableViewerComposite2, String actionLabel, int style, Feature feature) {
            super(gridTableViewerComposite2, actionLabel, style);
            this.setCurrentColumnProvider(() -> GridTableViewerComposite.access$5(GridTableViewerComposite.this));
            this.feature = feature;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && GridTableViewerComposite.this.getEnabledFeatures().contains(this.feature);
        }
    }

    private class GridColumnFilterViewerFilter
    extends AbstractGridColumnFilterViewerFilter {
        GridColumnFilterViewerFilter() {
            super(ColumnConfiguration.FEATURE_COLUMN_FILTER);
        }

        @Override
        protected boolean matchesColumnFilter(Object value, Object filterValue) {
            if (filterValue == null) {
                return false;
            }
            return String.valueOf(value).toLowerCase().contains(String.valueOf(filterValue).toLowerCase());
        }
    }

    private class GridColumnRegexFilterViewerFilter
    extends AbstractGridColumnFilterViewerFilter {
        private Object rawFilter;
        private Pattern pattern;

        GridColumnRegexFilterViewerFilter() {
            super(ColumnConfiguration.FEATURE_COLUMN_REGEX_FILTER);
        }

        @Override
        protected boolean matchesColumnFilter(Object value, Object filterValue) {
            if (!Objects.equals(filterValue, this.rawFilter)) {
                this.pattern = this.parse(String.valueOf(filterValue));
            }
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(String.valueOf(value)).find();
        }

        protected Pattern parse(String regex) {
            Pattern result = null;
            try {
                result = Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
            return result;
        }
    }
}

