/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.merge;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="replaceLiteral", label="Replace Literal", description="In the metamodel, an enum literal is removed and replaced by another one. In the model, the enum's values are replaced accordingly.", breaking=true)
public class ReplaceLiteral
extends OperationImplementation {
    @EdaptParameter(main=true, description="The enum literal to replace")
    public EEnumLiteral toReplace;
    @EdaptParameter(description="The enum literal by which it is replaced")
    public EEnumLiteral replaceBy;

    @EdaptConstraint(restricts="replaceBy", description="The enum literal by which it is replace must belong to the same enum.")
    public boolean checkReplaceBy(EEnumLiteral replaceBy) {
        return this.toReplace.getEEnum().getELiterals().contains((Object)replaceBy);
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EEnum contextEnum = this.toReplace.getEEnum();
        metamodel.delete((EModelElement)this.toReplace);
        EList attributes = metamodel.getInverse((EModelElement)contextEnum, EcorePackage.Literals.EATTRIBUTE__EATTRIBUTE_TYPE);
        for (EAttribute attribute : attributes) {
            EClass contextClass = attribute.getEContainingClass();
            for (Instance instance : model.getAllInstances(contextClass)) {
                if (instance.get((EStructuralFeature)attribute) != this.toReplace) continue;
                instance.set((EStructuralFeature)attribute, (Object)this.replaceBy);
            }
        }
    }
}

