/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.internal.migration;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecp.ide.internal.migration.Messages;
import org.eclipse.emf.ecp.internal.ui.validation.ValidationTreeViewerFactory;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ViewMigrationResultDialog
extends TitleAreaDialog {
    private final List<Diagnostic> errors = new LinkedList<Diagnostic>();
    private final List<String> unresolvedViews = new LinkedList<String>();

    public ViewMigrationResultDialog(Shell parentShell, Map<String, Optional<Diagnostic>> diagnostics) {
        super(parentShell);
        for (Map.Entry<String, Optional<Diagnostic>> diagnostic : diagnostics.entrySet()) {
            Optional<Diagnostic> diag = diagnostic.getValue();
            if (diag.isPresent() && ((Diagnostic)diag.get()).getSeverity() == 4) {
                this.errors.add((Diagnostic)diag.get());
                continue;
            }
            if (diag.isPresent()) continue;
            this.unresolvedViews.add(diagnostic.getKey());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ViewMigrationResultDialog_ShellTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.ViewMigrationResultDialog_Title);
        this.setMessage(this.errors.isEmpty() ? Messages.ViewMigrationResultDialog_MigrationSuccessMessage : Messages.ViewMigrationResultDialog_MigrationFailureMessage);
    }

    protected Control createDialogArea(Composite parent) {
        Label label;
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout(1, true));
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        if (this.errors.isEmpty() && this.unresolvedViews.isEmpty()) {
            label = new Label(container, 0);
            label.setText(Messages.ViewMigrationResultDialog_MigrationSuccess);
            label.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        if (!this.errors.isEmpty()) {
            TreeViewer diagnosticView = ValidationTreeViewerFactory.createValidationViewer((Composite)container);
            diagnosticView.setInput(this.errors);
            diagnosticView.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        }
        if (!this.unresolvedViews.isEmpty()) {
            label = new Label(container, 0);
            label.setText(Messages.ViewMigrationResultDialog_UnresolvedViews);
            label.setLayoutData((Object)new GridData(4, 4, true, true));
            ListViewer listViewer = new ListViewer(container);
            listViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
            listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            listViewer.setInput(this.unresolvedViews);
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

