/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class EMFFormsSpreadsheetRendererFactoryImpl
implements EMFFormsSpreadsheetRendererFactory {
    private final Set<EMFFormsSpreadsheetRendererService<VElement>> rendererServices = new LinkedHashSet<EMFFormsSpreadsheetRendererService<VElement>>();

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addEMFFormsSpreadsheetRendererService(EMFFormsSpreadsheetRendererService<VElement> spreadsheetRendererService) {
        this.rendererServices.add(spreadsheetRendererService);
    }

    @Override
    public void removeEMFFormsSpreadsheetRendererService(EMFFormsSpreadsheetRendererService<VElement> spreadsheetRendererService) {
        this.rendererServices.remove(spreadsheetRendererService);
    }

    @Override
    public <VELEMENT extends VElement> EMFFormsAbstractSpreadsheetRenderer<VElement> getRendererInstance(VELEMENT vElement, ViewModelContext viewModelContext) throws EMFFormsNoRendererException {
        Assert.create(vElement).notNull();
        Assert.create((Object)viewModelContext).notNull();
        EMFFormsSpreadsheetRendererService<VElement> bestFitting = null;
        double highestPriority = Double.NEGATIVE_INFINITY;
        for (EMFFormsSpreadsheetRendererService<VElement> rendererService : this.rendererServices) {
            double currentPriority = rendererService.isApplicable(vElement, viewModelContext);
            if (!(currentPriority > highestPriority)) continue;
            highestPriority = currentPriority;
            bestFitting = rendererService;
        }
        if (bestFitting == null) {
            throw new EMFFormsNoRendererException(String.format("No fitting renderer for %1$s found!", vElement.eClass().getName()));
        }
        return bestFitting.getRendererInstance(vElement, viewModelContext);
    }
}

