/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.common.prevalidation;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.internal.common.prevalidation.PreSetValidator;
import org.eclipse.emfforms.spi.common.validation.IFeatureConstraint;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(name="PreSetValidationServiceImpl", service={PreSetValidationService.class})
public class PreSetValidationServiceImpl
implements PreSetValidationService {
    private static final String LOOSE_PATTERN_KEY = "loosePattern";
    private static final String LOOSE_MIN_LENGTH = "looseMinLength";
    private static final String MULTI_LITERAL_SEP = "|";
    private static final String ESCAPED_MULTI_LITERAL_SEP = "\\|";
    private Map<ENamedElement, Set<IFeatureConstraint>> constraints = new LinkedHashMap<ENamedElement, Set<IFeatureConstraint>>();

    public Diagnostic validate(EStructuralFeature eStructuralFeature, Object value) {
        return this.validate(eStructuralFeature, value, null);
    }

    public Diagnostic validate(final EStructuralFeature eStructuralFeature, Object value, Map<Object, Object> context) {
        return this.validate(new PreSetValidator(){

            @Override
            public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
                EValidator validator = EValidator.Registry.INSTANCE.getEValidator(eStructuralFeature.getEType().getEPackage());
                if (validator == null) {
                    validator = new EObjectValidator();
                }
                return validator.validate(eDataType, value, diagnostics, context);
            }
        }, eStructuralFeature, value, context);
    }

    public Diagnostic validateLoose(EStructuralFeature eStructuralFeature, Object value) {
        EClassifier eType = eStructuralFeature.getEType();
        if (!EDataType.class.isInstance(eType) || ((EDataType)EDataType.class.cast(eType)).getEPackage() == EcorePackage.eINSTANCE) {
            return new BasicDiagnostic();
        }
        return this.validate(new DynamicLoosePatternEValidator(new LooseEValidator(), (EDataType)eType), eStructuralFeature, value, null);
    }

    private Diagnostic validate(PreSetValidator validator, EStructuralFeature eStructuralFeature, Object value, Map<Object, Object> context) {
        EClassifier eType = eStructuralFeature.getEType();
        BasicDiagnostic diagnostics = new BasicDiagnostic();
        if (eType instanceof EDataType && ((EDataType)EDataType.class.cast(eType)).getEPackage() != EcorePackage.eINSTANCE) {
            EDataType eDataType = (EDataType)EDataType.class.cast(eType);
            diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(eDataType, value);
            if (eDataType instanceof EEnum && value instanceof String) {
                if (PreSetValidationServiceImpl.validateEEnum((EEnum)eDataType, (String)value)) {
                    return new BasicDiagnostic();
                }
            } else if (eDataType instanceof EEnum && value instanceof List) {
                try {
                    if (PreSetValidationServiceImpl.validateEEnum((EEnum)eDataType, (List)value)) {
                        return new BasicDiagnostic();
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (validator != null) {
                validator.validate(eDataType, value, (DiagnosticChain)diagnostics, context);
            }
        }
        PreSetValidationServiceImpl.executeValidators(diagnostics, this.constraints.get(eType), eStructuralFeature, value, context);
        PreSetValidationServiceImpl.executeValidators(diagnostics, this.constraints.get(eStructuralFeature), eStructuralFeature, value, context);
        return diagnostics;
    }

    private static boolean validateEEnum(EEnum eEnum, String valueString) {
        if (valueString.contains(MULTI_LITERAL_SEP)) {
            String[] literals;
            boolean isValid = true;
            String[] stringArray = literals = valueString.split(ESCAPED_MULTI_LITERAL_SEP);
            int n = literals.length;
            int n2 = 0;
            while (n2 < n) {
                String literal = stringArray[n2];
                isValid &= PreSetValidationServiceImpl.validateLiteral(eEnum, literal.trim());
                ++n2;
            }
            return isValid;
        }
        return PreSetValidationServiceImpl.validateLiteral(eEnum, valueString);
    }

    private static boolean validateEEnum(EEnum eEnum, List<Enumerator> enumerators) {
        boolean isValid = true;
        for (Enumerator enumerator : enumerators) {
            isValid &= PreSetValidationServiceImpl.validateLiteral(eEnum, enumerator.getLiteral());
        }
        return isValid;
    }

    private static Optional<String> findLooseConstraint(EDataType eDataType, String looseConstrainKey) {
        return Optional.ofNullable((Object)EcoreUtil.getAnnotation((EModelElement)eDataType, (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)looseConstrainKey));
    }

    private static boolean validateLiteral(EEnum eEnum, String literal) {
        for (EEnumLiteral enumLiteral : eEnum.getELiterals()) {
            if (!literal.equals(enumLiteral.getLiteral())) continue;
            return true;
        }
        return false;
    }

    private static void executeValidators(BasicDiagnostic diagnostics, Set<IFeatureConstraint> constraints, EStructuralFeature eStructuralFeature, Object value, Map<Object, Object> context) {
        if (constraints == null) {
            return;
        }
        for (IFeatureConstraint constraint : constraints) {
            Diagnostic result = constraint.validate(eStructuralFeature, value, context);
            if (result.getSeverity() == 0) continue;
            diagnostics.add(result);
        }
    }

    public void addConstraintValidator(ENamedElement element, IFeatureConstraint constraint) {
        if (!this.constraints.containsKey(element)) {
            this.constraints.put(element, new LinkedHashSet());
        }
        this.constraints.get(element).add(constraint);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.constraints = new LinkedHashMap<ENamedElement, Set<IFeatureConstraint>>();
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        this.constraints = null;
    }

    class DynamicLoosePatternEValidator
    extends EObjectValidator.DynamicEDataTypeValidator
    implements PreSetValidator {
        DynamicLoosePatternEValidator(EObjectValidator eObjectValidator, EDataType eDataType) {
            EObjectValidator eObjectValidator2 = eObjectValidator;
            eObjectValidator2.getClass();
            super(eObjectValidator2, eDataType);
        }

        protected boolean validateSchemaConstraints(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
            Optional looseMinLength = PreSetValidationServiceImpl.findLooseConstraint(eDataType, PreSetValidationServiceImpl.LOOSE_MIN_LENGTH);
            if (looseMinLength.isPresent()) {
                this.effectiveMinLength = Integer.parseInt((String)looseMinLength.get());
                super.validateSchemaConstraints(eDataType, value, diagnostics, context);
            }
            return super.validateSchemaConstraints(eDataType, value, diagnostics, context);
        }
    }

    class LooseEValidator
    extends EObjectValidator
    implements PreSetValidator {
        LooseEValidator() {
        }

        protected boolean validatePattern(EDataType eDataType, Object value, EValidator.PatternMatcher[][] patterns, DiagnosticChain diagnostics, Map<Object, Object> context) {
            final Optional loosePattern = PreSetValidationServiceImpl.findLooseConstraint(eDataType, PreSetValidationServiceImpl.LOOSE_PATTERN_KEY);
            if (loosePattern.isPresent()) {
                return super.validatePattern(eDataType, value, (EValidator.PatternMatcher[][])new EValidator.PatternMatcher[][]{{new EValidator.PatternMatcher(){

                    public boolean matches(String value) {
                        Pattern pattern = Pattern.compile((String)loosePattern.get());
                        Matcher matcher = pattern.matcher(value);
                        return matcher.matches();
                    }
                }}}, diagnostics, context);
            }
            return super.validatePattern(eDataType, value, patterns, diagnostics, context);
        }
    }
}

