/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPEnumCellEditor;
import org.eclipse.emf.ecp.view.internal.core.swt.ComboUtil;
import org.eclipse.emf.ecp.view.internal.core.swt.MatchItemComboViewer;
import org.eclipse.emf.ecp.view.internal.table.swt.FigureUtilities;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.table.swt.SelectedEnumeratorMapping;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnumCellEditor
extends ECPEnumCellEditor {
    private static final String EMPTY = "";
    private EEnum eEnum;
    private MatchItemComboViewer viewer;
    private int minWidth;
    private String text;
    private EnumCellEditorLabelProvider labelProvider;

    public EnumCellEditor(Composite parent) {
        super(parent);
    }

    public EnumCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public IValueProperty getValueProperty() {
        return new ComboValueProperty();
    }

    public void instantiate(EStructuralFeature feature, ViewModelContext viewModelContext) {
        EAttribute attribute = (EAttribute)EAttribute.class.cast(feature);
        this.eEnum = (EEnum)EEnum.class.cast(attribute.getEAttributeType());
        int literalsSize = this.getELiterals().size();
        this.viewer.getCCombo().setVisibleItemCount(literalsSize <= 25 ? literalsSize : 25);
        Point emptyViewerSize = this.viewer.getCCombo().computeSize(-1, -1, true);
        this.minWidth = 50;
        for (EEnumLiteral literal : this.getELiterals()) {
            String string = literal.getInstance().getLiteral();
            int newWidth = FigureUtilities.getTextWidth(string, this.viewer.getCCombo().getFont());
            if (newWidth <= this.minWidth) continue;
            this.minWidth = newWidth;
        }
        this.minWidth += emptyViewerSize.x;
    }

    public String getFormatedString(Object value) {
        if (value != null) {
            Enumerator enumerator = (Enumerator)value;
            return enumerator.getLiteral();
        }
        return EMPTY;
    }

    public int getColumnWidthWeight() {
        return 100;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public Image getImage(Object value) {
        return null;
    }

    public UpdateValueStrategy getTargetToModelStrategy(DataBindingContext databindingContext) {
        return new TargetToModelStrategy();
    }

    public UpdateValueStrategy getModelToTargetStrategy(DataBindingContext databindingContext) {
        return new ModelToTargetStrategy();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData data = new CellEditor.LayoutData();
        data.minimumWidth = 0;
        return data;
    }

    public void setEditable(boolean editable) {
        this.viewer.getCCombo().setEnabled(editable);
    }

    protected Control createControl(Composite parent) {
        this.viewer = new MatchItemComboViewer(new CCombo(parent, 0)){

            public void onEnter() {
                int selectedIndex = ComboUtil.getClosestMatchIndex((String[])this.getCCombo().getItems(), (String)this.getBuffer().asString());
                if (!this.getBuffer().isEmpty() && selectedIndex > -1) {
                    String closestMatch = this.getCCombo().getItems()[selectedIndex];
                    Optional<SelectedEnumeratorMapping> selectedMappping = SelectedEnumeratorMapping.findLiteral((SelectedEnumeratorMapping[])this.getInput(), closestMatch);
                    if (selectedMappping.isPresent()) {
                        this.setSelection((ISelection)new StructuredSelection(selectedMappping.get()));
                    }
                } else {
                    this.setClosestMatch(this.getCCombo().getText());
                }
                EnumCellEditor.this.focusLost();
            }

            protected void onEscape() {
                EnumCellEditor.this.fireCancelEditor();
            }
        };
        CCombo combo = this.viewer.getCCombo();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
        this.labelProvider = new EnumCellEditorLabelProvider();
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        return combo;
    }

    protected Object doGetValue() {
        return this.viewer.getInput();
    }

    protected void doSetFocus() {
        CCombo combo = this.viewer.getCCombo();
        if (combo == null || combo.isDisposed()) {
            return;
        }
        combo.setFocus();
        String text = combo.getText();
        if (text != null) {
            combo.setSelection(new Point(text.length(), text.length()));
        }
    }

    public void activate(ColumnViewerEditorActivationEvent actEvent) {
        CCombo control;
        super.activate(actEvent);
        if (actEvent.eventType == 1 && (control = (CCombo)this.getControl()) != null && Character.isLetterOrDigit(actEvent.character)) {
            this.viewer.getBuffer().reset();
            this.viewer.getBuffer().addLast(Character.valueOf(actEvent.character));
        }
    }

    public void deactivate() {
        Optional<SelectedEnumeratorMapping> sel;
        SelectedEnumeratorMapping[] selectedMapping;
        CCombo control = (CCombo)this.getControl();
        if (control != null && !control.isDisposed()) {
            this.text = control.getText();
            String string = this.text = this.text == null ? EMPTY : this.text;
        }
        if ((selectedMapping = (SelectedEnumeratorMapping[])this.viewer.getInput()) != null && (sel = SelectedEnumeratorMapping.findLiteral(selectedMapping, this.text)).isPresent()) {
            ((SelectedEnumeratorMapping)sel.get()).setSelected(true);
            this.viewer.setSelection((ISelection)new StructuredSelection(sel.get()));
        }
        this.text = EMPTY;
        this.viewer.getBuffer().reset();
        if (control != null && !control.isDisposed()) {
            control.setText(EMPTY);
        }
        super.deactivate();
    }

    protected void doSetValue(Object value) {
        this.viewer.setInput(value);
    }

    private String getComboText(SelectedEnumeratorMapping[] input) {
        Optional<Enumerator> selected = SelectedEnumeratorMapping.findSelected(input);
        if (selected.isPresent()) {
            return ((Enumerator)selected.get()).getLiteral();
        }
        return EMPTY;
    }

    public EEnum getEEnum() {
        return this.eEnum;
    }

    private class ComboObservableValue
    extends AbstractObservableValue {
        private final EnumSelectionAdapter selectionAdapter = new EnumSelectionAdapter();

        ComboObservableValue() {
            EnumCellEditor.this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionAdapter);
        }

        public Object getValueType() {
            return null;
        }

        protected Object doGetValue() {
            return EnumCellEditor.this.viewer.getInput();
        }

        protected void doSetValue(Object value) {
            EnumCellEditor.this.viewer.setInput(value);
            EnumCellEditor.this.viewer.getCCombo().setText(EnumCellEditor.this.getComboText((SelectedEnumeratorMapping[])value));
        }

        public synchronized void dispose() {
            EnumCellEditor.this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.selectionAdapter);
            super.dispose();
        }

        private class EnumSelectionAdapter
        implements ISelectionChangedListener {
            private EnumSelectionAdapter() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                SelectedEnumeratorMapping mapping = (SelectedEnumeratorMapping)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (mapping == null) {
                    return;
                }
                SelectedEnumeratorMapping[] allMapping = (SelectedEnumeratorMapping[])EnumCellEditor.this.viewer.getInput();
                SelectedEnumeratorMapping.deselectAll(allMapping);
                mapping.setSelected(!mapping.isSelected());
                EnumCellEditor.this.viewer.getCCombo().setText(EnumCellEditor.this.getComboText((SelectedEnumeratorMapping[])EnumCellEditor.this.viewer.getInput()));
                EnumCellEditor.this.viewer.update((Object)mapping, null);
                ComboObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)(!mapping.isSelected() ? 1 : 0), (Object)mapping.isSelected()));
            }
        }
    }

    private class ComboValueProperty
    extends WidgetValueProperty {
        private ComboValueProperty() {
        }

        public Object getValueType() {
            return CCombo.class;
        }

        protected Object doGetValue(Object source) {
            return EnumCellEditor.this.getValue();
        }

        protected void doSetValue(Object source, Object value) {
            EnumCellEditor.this.doSetValue(value);
        }

        public IObservableValue observe(Object source) {
            return new ComboObservableValue();
        }
    }

    private class EnumCellEditorLabelProvider
    extends LabelProvider {
        private EnumCellEditorLabelProvider() {
        }

        public String getText(Object element) {
            SelectedEnumeratorMapping mapping = (SelectedEnumeratorMapping)element;
            return mapping.getEnumerator().getLiteral();
        }
    }

    private class ModelToTargetStrategy
    extends EMFUpdateValueStrategy {
        private ModelToTargetStrategy() {
        }

        public Object convert(Object value) {
            Enumerator enumerator = (Enumerator)value;
            SelectedEnumeratorMapping[] mapping = SelectedEnumeratorMapping.createFromList(EnumCellEditor.this.getELiterals());
            SelectedEnumeratorMapping.select(mapping, enumerator);
            return mapping;
        }
    }

    private class TargetToModelStrategy
    extends EMFUpdateValueStrategy {
        private TargetToModelStrategy() {
        }

        public Object convert(Object value) {
            SelectedEnumeratorMapping[] mapping = (SelectedEnumeratorMapping[])value;
            Optional<Enumerator> selected = SelectedEnumeratorMapping.findSelected(mapping);
            return selected.orNull();
        }
    }
}

