/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.ui.view.swt.DefaultReferenceService;
import org.eclipse.emf.ecp.ui.view.swt.reference.AttachmentStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.EClassSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.EObjectSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.OpenInNewContextStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceStrategy;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emfforms.bazaar.Bazaar;
import org.eclipse.emfforms.bazaar.BazaarContext;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.bazaar.StaticBid;
import org.eclipse.emfforms.bazaar.Vendor;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceFactory;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServicePolicy;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewServiceScope;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class DefaultReferenceServiceFactory
implements EMFFormsViewServiceFactory<ReferenceService> {
    private ComponentContext context;
    private final Bazaar<EObjectSelectionStrategy> eobjectSelectionStrategyBazaar = DefaultReferenceServiceFactory.createBazaar(EObjectSelectionStrategy.NULL);
    private final Bazaar<EClassSelectionStrategy> eclassSelectionStrategyBazaar = DefaultReferenceServiceFactory.createBazaar(EClassSelectionStrategy.NULL);
    private final Bazaar<AttachmentStrategy> attachmentStrategyBazaar = DefaultReferenceServiceFactory.createBazaar(AttachmentStrategy.DEFAULT);
    private final Bazaar<ReferenceStrategy> referenceStrategyBazaar = DefaultReferenceServiceFactory.createBazaar(ReferenceStrategy.DEFAULT);
    private final Bazaar<OpenInNewContextStrategy> openInNewContextStrategyBazaar = DefaultReferenceServiceFactory.createBazaar(OpenInNewContextStrategy.DEFAULT);

    private static <T> Bazaar<T> createBazaar(T defaultStrategy) {
        Bazaar.Builder<T> builder = DefaultReferenceServiceFactory.builder(defaultStrategy);
        return builder.build();
    }

    private static <T> Bazaar.Builder<T> builder(T defaultStrategy) {
        Bazaar.Builder result = Bazaar.Builder.empty();
        @StaticBid(bid=-Infinity)
        class DefaultVendor
        implements Vendor<T> {
            private final /* synthetic */ Object val$defaultStrategy;

            DefaultVendor(Object object) {
                this.val$defaultStrategy = object;
            }

            @Create
            public T createDefault() {
                return this.val$defaultStrategy;
            }
        }
        return result.threadSafe().add((Vendor)new DefaultVendor(defaultStrategy));
    }

    public EMFFormsViewServicePolicy getPolicy() {
        return EMFFormsViewServicePolicy.LAZY;
    }

    public EMFFormsViewServiceScope getScope() {
        return EMFFormsViewServiceScope.LOCAL;
    }

    public double getPriority() {
        return 1.0;
    }

    public Class<ReferenceService> getType() {
        return ReferenceService.class;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addAttachmentStrategyProvider(AttachmentStrategy.Provider provider) {
        this.attachmentStrategyBazaar.addVendor((Vendor)provider);
    }

    void removeAttachmentStrategyProvider(AttachmentStrategy.Provider provider) {
        this.attachmentStrategyBazaar.removeVendor((Vendor)provider);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addOpenInNewContextStrategyProvider(OpenInNewContextStrategy.Provider provider) {
        this.openInNewContextStrategyBazaar.addVendor((Vendor)provider);
    }

    void removeOpenInNewContextStrategyProvider(OpenInNewContextStrategy.Provider provider) {
        this.openInNewContextStrategyBazaar.removeVendor((Vendor)provider);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addEClassSelectionStrategyProvider(EClassSelectionStrategy.Provider provider) {
        this.eclassSelectionStrategyBazaar.addVendor((Vendor)provider);
    }

    void removeEClassSelectionStrategyProvider(EClassSelectionStrategy.Provider provider) {
        this.eclassSelectionStrategyBazaar.removeVendor((Vendor)provider);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addEObjectSelectionStrategyProvider(EObjectSelectionStrategy.Provider provider) {
        this.eobjectSelectionStrategyBazaar.addVendor((Vendor)provider);
    }

    void removeEObjectSelectionStrategyProvider(EObjectSelectionStrategy.Provider provider) {
        this.eobjectSelectionStrategyBazaar.removeVendor((Vendor)provider);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addReferenceStrategyProvider(ReferenceStrategy.Provider provider) {
        this.referenceStrategyBazaar.addVendor((Vendor)provider);
    }

    void removeReferenceStrategyProvider(ReferenceStrategy.Provider provider) {
        this.referenceStrategyBazaar.removeVendor((Vendor)provider);
    }

    @Activate
    void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    void deactivate() {
        this.context = null;
    }

    public ReferenceService createService(EMFFormsViewContext emfFormsViewContext) {
        if (emfFormsViewContext instanceof ViewModelContext) {
            DefaultReferenceService drs = new DefaultReferenceService();
            drs.setAttachmentStrategy(this.createDynamicAttachmentStrategy());
            drs.setEClassSelectionStrategy(this.createDynamicEClassSelectionStrategy());
            drs.setEObjectSelectionStrategy(this.createDynamicEObjectSelectionStrategy());
            drs.setOpenStrategy(this.createDynamicOpenInNewContextStrategy());
            drs.setReferenceStrategy(this.createDynamicReferenceStrategy());
            drs.instantiate((ViewModelContext)emfFormsViewContext);
            return drs;
        }
        throw new IllegalStateException("The provided context is not a ViewModelContext.");
    }

    private BazaarContext getBazaarContext(EObject owner, EReference reference) {
        return this.baseContext(owner, reference).build();
    }

    private BazaarContext.Builder baseContext(EObject owner, EReference reference) {
        return BazaarContext.Builder.with(DefaultReferenceServiceFactory.adapt(this.context.getProperties())).put(EObject.class, (Object)owner).put(EReference.class, (Object)reference);
    }

    static Map<String, ?> adapt(Dictionary<String, ?> dictionary) {
        if (dictionary instanceof Map) {
            Map result = (Map)((Object)dictionary);
            return result;
        }
        HashMap result = new HashMap();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String next = keys.nextElement();
            result.put(next, dictionary.get(next));
        }
        return result;
    }

    private AttachmentStrategy createDynamicAttachmentStrategy() {
        return new AttachmentStrategy(){

            @Override
            public boolean addElementToModel(EObject owner, EReference reference, EObject object) {
                AttachmentStrategy delegate = (AttachmentStrategy)DefaultReferenceServiceFactory.this.attachmentStrategyBazaar.createProduct(DefaultReferenceServiceFactory.this.getBazaarContext(owner, reference));
                if (delegate == null) {
                    return false;
                }
                return delegate.addElementToModel(owner, reference, object);
            }
        };
    }

    private ReferenceStrategy createDynamicReferenceStrategy() {
        return new ReferenceStrategy(){

            @Override
            public boolean addElementsToReference(EObject owner, EReference reference, Set<? extends EObject> objects) {
                ReferenceStrategy delegate = (ReferenceStrategy)DefaultReferenceServiceFactory.this.referenceStrategyBazaar.createProduct(DefaultReferenceServiceFactory.this.getBazaarContext(owner, reference));
                if (delegate == null) {
                    return false;
                }
                return delegate.addElementsToReference(owner, reference, objects);
            }
        };
    }

    private EClassSelectionStrategy createDynamicEClassSelectionStrategy() {
        return new EClassSelectionStrategy(){

            @Override
            public Collection<EClass> collectEClasses(EObject owner, EReference reference, Collection<EClass> eclasses) {
                Collection<EClass> result = eclasses;
                List delegates = DefaultReferenceServiceFactory.this.eclassSelectionStrategyBazaar.createProducts(DefaultReferenceServiceFactory.this.getBazaarContext(owner, reference));
                for (EClassSelectionStrategy next : delegates) {
                    result = next.collectEClasses(owner, reference, result);
                }
                return result;
            }
        };
    }

    private EObjectSelectionStrategy createDynamicEObjectSelectionStrategy() {
        return new EObjectSelectionStrategy(){

            @Override
            public Collection<EObject> collectExistingObjects(EObject owner, EReference reference, Collection<EObject> existingObjects) {
                Collection<EObject> result = existingObjects;
                List delegates = DefaultReferenceServiceFactory.this.eobjectSelectionStrategyBazaar.createProducts(DefaultReferenceServiceFactory.this.getBazaarContext(owner, reference));
                for (EObjectSelectionStrategy next : delegates) {
                    result = next.collectExistingObjects(owner, reference, result);
                }
                return result;
            }
        };
    }

    private OpenInNewContextStrategy createDynamicOpenInNewContextStrategy() {
        return new OpenInNewContextStrategy(){

            @Override
            public boolean openInNewContext(EObject owner, EReference reference, EObject object) {
                OpenInNewContextStrategy delegate = (OpenInNewContextStrategy)DefaultReferenceServiceFactory.this.openInNewContextStrategyBazaar.createProduct(DefaultReferenceServiceFactory.this.getBazaarContext(owner, reference));
                if (delegate == null) {
                    return false;
                }
                return delegate.openInNewContext(owner, reference, object);
            }
        };
    }
}

