/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.makeithappen.model.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Gender implements Enumerator
{
    MALE(0, "Male", "Male"),
    FEMALE(1, "Female", "Female");

    public static final int MALE_VALUE = 0;
    public static final int FEMALE_VALUE = 1;
    private static final Gender[] VALUES_ARRAY;
    public static final List<Gender> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Gender[]{MALE, FEMALE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Gender get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Gender result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Gender getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Gender result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Gender get(int value) {
        switch (value) {
            case 0: {
                return MALE;
            }
            case 1: {
                return FEMALE;
            }
        }
        return null;
    }

    private Gender(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

