/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelFactory;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="extractClass", label="Extract Class", description="In the metamodel, a number of features are extracted to a new class. This new class is accessible from the context class through a new containment reference. In the model, the values of the features are extracted to a new instance accordingly.", breaking=true)
public class ExtractClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The context class from which the features are extracted")
    public EClass contextClass;
    @EdaptParameter(optional=true, description="The features to be extracted")
    public List<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
    @EdaptParameter(description="The package in which the extracted class is created")
    public EPackage ePackage;
    @EdaptParameter(description="The name of the extracted class")
    public String className;
    @EdaptParameter(description="The name of the new containment reference from context to extracted class")
    public String referenceName;

    @EdaptConstraint(restricts="features", description="The features have to belong to the same class")
    public boolean checkFeatures(EStructuralFeature feature) {
        return this.contextClass.getEStructuralFeatures().contains((Object)feature);
    }

    @EdaptConstraint(description="A classifier with the same name already exists")
    public boolean checkUniqueClassifierName() {
        return this.ePackage.getEClassifier(this.className) == null;
    }

    @EdaptConstraint(description="A feature with the same name already exists")
    public boolean checkUniqueFeatureName() {
        EStructuralFeature feature = this.contextClass.getEStructuralFeature(this.referenceName);
        return feature == null || this.features.contains(feature);
    }

    @Override
    public void initialize(Metamodel metamodel) {
        if (this.ePackage == null) {
            this.ePackage = this.contextClass.getEPackage();
        }
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass extractedClass = MetamodelFactory.newEClass((EPackage)this.ePackage, (String)this.className);
        EReference reference = MetamodelFactory.newEReference((EClass)this.contextClass, (String)this.referenceName, (EClass)extractedClass, (int)1, (int)1, (boolean)true);
        extractedClass.getEStructuralFeatures().addAll(this.features);
        for (EStructuralFeature feature : this.features) {
            EReference r;
            if (!(feature instanceof EReference) || (r = (EReference)feature).getEOpposite() == null) continue;
            r.getEOpposite().setEType((EClassifier)extractedClass);
        }
        for (Instance contextInstance : model.getAllInstances(this.contextClass)) {
            Instance extractedInstance = model.newInstance(extractedClass);
            contextInstance.set((EStructuralFeature)reference, (Object)extractedInstance);
            for (EStructuralFeature feature : this.features) {
                extractedInstance.set(feature, contextInstance.unset(feature));
            }
        }
    }
}

