/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.tooling.editor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelMigrationException;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelMigratorUtil;
import org.eclipse.emf.ecp.spi.view.migrator.TemplateModelWorkspaceMigrator;
import org.eclipse.emf.ecp.spi.view.migrator.ViewNsMigrationUtil;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.emf.ecp.view.template.internal.tooling.util.MigrationDialogHelper;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.selector.domainmodelreference.model.VTDomainModelReferenceSelector;
import org.eclipse.emfforms.spi.core.services.segments.LegacyDmrToRootEClass;
import org.eclipse.emfforms.spi.editor.GenericEditor;
import org.eclipse.emfforms.spi.ide.view.segments.DmrToSegmentsMigrationException;
import org.eclipse.emfforms.spi.ide.view.segments.DmrToSegmentsMigrator;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.RootObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class TemplateModelEditorPart
extends GenericEditor {
    private VTViewTemplate template;
    private TreeMasterDetailComposite treeMasterDetail;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        if (!(input instanceof FileEditorInput)) {
            throw new PartInitException(Messages.TemplateModelEditorPart_invalidEditorInput);
        }
        FileEditorInput fei = (FileEditorInput)input;
        try {
            this.registerReferencedEcores(URI.createURI((String)fei.getURI().toURL().toExternalForm()));
            if (!ViewNsMigrationUtil.checkMigration((File)fei.getPath().toFile())) {
                boolean migrate = MessageDialog.openQuestion((Shell)site.getShell(), (String)Messages.TemplateModelEditorPart_MigrationQuestion, (String)Messages.TemplateModelEditorPart_MigrationDescription);
                if (migrate) {
                    ViewNsMigrationUtil.migrateViewEcoreNsUri((File)fei.getPath().toFile());
                    this.migrateWorkspaceModels(site.getShell());
                    if (ToolingModeUtil.isSegmentToolingEnabled()) {
                        this.migrateLegacyDmrs(site.getShell(), fei.getPath());
                    }
                }
            } else if (ToolingModeUtil.isSegmentToolingEnabled()) {
                this.migrateLegacyDmrs(site.getShell(), fei.getPath());
            }
        }
        catch (IOException e) {
            Activator.log(e);
            throw new PartInitException(Messages.TemplateModelEditorPart_initError, (Throwable)e);
        }
        super.init(site, input);
        super.setPartName(input.getName());
    }

    private void registerReferencedEcores(URI resourceUri) throws IOException, PartInitException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(resourceUri);
        resource.load(Collections.singletonMap("RECORD_UNKNOWN_FEATURE", Boolean.TRUE));
        EList resourceContents = resource.getContents();
        if (resourceContents.size() > 0 && VTViewTemplate.class.isInstance(resourceContents.get(0))) {
            VTViewTemplate template = (VTViewTemplate)resourceContents.get(0);
            for (String ecorePath : template.getReferencedEcores()) {
                EcoreHelper.registerEcore((String)ecorePath);
            }
        } else {
            throw new PartInitException(Messages.TemplateModelEditorPart_initError);
        }
    }

    protected Object modifyEditorInput(ResourceSet resourceSet) {
        int rsSize = this.getResourceSet().getResources().size();
        EcoreUtil.resolveAll((ResourceSet)this.getResourceSet());
        while (rsSize != this.getResourceSet().getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)this.getResourceSet());
            rsSize = this.getResourceSet().getResources().size();
        }
        this.template = (VTViewTemplate)VTViewTemplate.class.cast(((Resource)resourceSet.getResources().get(0)).getContents().get(0));
        return new RootObject((EObject)this.template);
    }

    protected TreeMasterDetailComposite createTreeMasterDetail(Composite composite, Object editorInput, CreateElementCallback createElementCallback) {
        this.treeMasterDetail = super.createTreeMasterDetail(composite, editorInput, createElementCallback);
        return this.treeMasterDetail;
    }

    public void dispose() {
        if (this.template != null) {
            for (String ecorePath : this.template.getReferencedEcores()) {
                EcoreHelper.unregisterEcore((String)ecorePath);
            }
        }
        super.dispose();
    }

    public VTViewTemplate getTemplate() {
        return this.template;
    }

    public void reveal(EObject objectToReveal) {
        this.treeMasterDetail.getSelectionProvider().refresh();
        this.treeMasterDetail.getSelectionProvider().reveal((Object)objectToReveal);
        this.treeMasterDetail.setSelection((ISelection)new StructuredSelection((Object)objectToReveal));
    }

    private void migrateLegacyDmrs(Shell shell, IPath resourcePath) {
        boolean migrate;
        URI resourceURI;
        DmrToSegmentsMigrator migrator = (DmrToSegmentsMigrator)this.getEditorSite().getService(DmrToSegmentsMigrator.class);
        if (migrator.needsMigration(resourceURI = URI.createFileURI((String)resourcePath.toFile().getAbsolutePath())) && (migrate = MessageDialog.openQuestion((Shell)shell, (String)Messages.TemplateModelEditorPart_LegacyMigrationQuestionTitle, (String)Messages.TemplateModelEditorPart_LegacyMigrationQuestionMessage))) {
            try {
                new ProgressMonitorDialog(shell).run(true, false, monitor -> {
                    try {
                        LegacyDmrToRootEClass dmrToRootEClass = (LegacyDmrToRootEClass)this.getEditorSite().getService(LegacyDmrToRootEClass.class);
                        migrator.performMigration(resourceURI, new DmrToSegmentsMigrator.PreReplaceProcessor[]{new DmrSelectorPreReplaceProcessor(dmrToRootEClass)});
                    }
                    catch (DmrToSegmentsMigrationException ex) {
                        throw new InvocationTargetException(ex);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.TemplateModelEditorPart_LegacyMigrationErrorTitle, (String)Messages.TemplateModelEditorPart_LegacyMigrationErrorMessage);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", Messages.TemplateModelEditorPart_LegacyMigrationErrorTitle, (Throwable)ex));
            }
        }
    }

    private void migrateWorkspaceModels(Shell shell) {
        final TemplateModelWorkspaceMigrator templateMigrator = TemplateModelMigratorUtil.getTemplateModelWorkspaceMigrator();
        if (templateMigrator == null) {
            return;
        }
        boolean migrateTemplates = MessageDialog.openQuestion((Shell)shell, (String)Messages.TemplateModelEditorPart_TemplateMigrationTitle, (String)Messages.TemplateModelEditorPart_TemplateMigrationDescription);
        if (migrateTemplates) {
            final List<URI> templateModelsToMigrate = this.getTemplateModelWorkspaceURIsToMigrate();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        for (URI uri : templateModelsToMigrate) {
                            templateMigrator.performMigration(uri);
                        }
                    }
                    catch (TemplateModelMigrationException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, false, runnable);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorMessage);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (Throwable)e));
            }
            catch (InterruptedException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (String)Messages.TemplateModelEditorPart_TemplateMigrationErrorMessage);
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", Messages.TemplateModelEditorPart_TemplateMigrationErrorTitle, (Throwable)e));
            }
        }
    }

    private List<URI> getTemplateModelWorkspaceURIsToMigrate() {
        LinkedList<URI> uris = new LinkedList<URI>();
        TemplateModelWorkspaceMigrator workspaceMigrator = TemplateModelMigratorUtil.getTemplateModelWorkspaceMigrator();
        if (workspaceMigrator == null) {
            return uris;
        }
        try {
            Object[] selectedURIs;
            Shell shell;
            ListSelectionDialog migrationDialog;
            List urIsToMigrate = workspaceMigrator.getURIsToMigrate();
            if (urIsToMigrate.size() > 0 && (migrationDialog = MigrationDialogHelper.getTemplateModelListMigrationDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), urIsToMigrate)).open() == 0 && (selectedURIs = migrationDialog.getResult()) != null) {
                Object[] objectArray = selectedURIs;
                int n = selectedURIs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedUri = objectArray[n2];
                    uris.add((URI)selectedUri);
                    ++n2;
                }
            }
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.template.tooling", ex.getMessage(), (Throwable)ex));
        }
        return uris;
    }

    protected boolean enableValidation() {
        return true;
    }

    protected static class DmrSelectorPreReplaceProcessor
    implements DmrToSegmentsMigrator.PreReplaceProcessor {
        private final LegacyDmrToRootEClass dmrToRootEClass;

        public DmrSelectorPreReplaceProcessor(LegacyDmrToRootEClass dmrToRootEClass) {
            this.dmrToRootEClass = dmrToRootEClass;
        }

        public void process(VDomainModelReference legacyDmr, VDomainModelReference segmentDmr) {
            if (legacyDmr.eContainer() instanceof VTDomainModelReferenceSelector) {
                VTDomainModelReferenceSelector selector = (VTDomainModelReferenceSelector)legacyDmr.eContainer();
                Optional rootEClass = this.dmrToRootEClass.getRootEClass(legacyDmr);
                rootEClass.ifPresent(arg_0 -> ((VTDomainModelReferenceSelector)selector).setRootEClass(arg_0));
            }
        }
    }
}

