/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DateTimeDisplayType implements Enumerator
{
    TIME_AND_DATE(0, "TimeAndDate", "TimeAndDate"),
    TIME_ONLY(1, "TimeOnly", "TimeOnly"),
    DATE_ONLY(2, "DateOnly", "DateOnly");

    public static final int TIME_AND_DATE_VALUE = 0;
    public static final int TIME_ONLY_VALUE = 1;
    public static final int DATE_ONLY_VALUE = 2;
    private static final DateTimeDisplayType[] VALUES_ARRAY;
    public static final List<DateTimeDisplayType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DateTimeDisplayType[]{TIME_AND_DATE, TIME_ONLY, DATE_ONLY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DateTimeDisplayType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateTimeDisplayType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateTimeDisplayType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateTimeDisplayType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateTimeDisplayType get(int value) {
        switch (value) {
            case 0: {
                return TIME_AND_DATE;
            }
            case 1: {
                return TIME_ONLY;
            }
            case 2: {
                return DATE_ONLY;
            }
        }
        return null;
    }

    private DateTimeDisplayType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

