/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.structuralchange;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsSegmentResolver;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeSegmentTester;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeTesterInternal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsStructuralChangeTesterImpl")
public class EMFFormsStructuralChangeTesterImpl
implements EMFFormsStructuralChangeTester {
    private ReportService reportService;
    private final Set<StructuralChangeTesterInternal> dmrChangeTesters = new LinkedHashSet<StructuralChangeTesterInternal>();
    private final Set<StructuralChangeSegmentTester> segmentChangeTesters = new LinkedHashSet<StructuralChangeSegmentTester>();
    private EMFFormsSegmentResolver segmentResolver;
    private static final RankingHelper<StructuralChangeTesterInternal> DMR_RANKING_HELPER = new RankingHelper(StructuralChangeTesterInternal.class, Double.NEGATIVE_INFINITY, Double.valueOf(Double.NEGATIVE_INFINITY));
    private static final RankingHelper<StructuralChangeSegmentTester> SEGMENTS_RANKING_HELPER = new RankingHelper(StructuralChangeSegmentTester.class, Double.NEGATIVE_INFINITY, Double.valueOf(Double.NEGATIVE_INFINITY));

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addStructuralChangeTesterInternal(StructuralChangeTesterInternal structuralChangeTester) {
        this.dmrChangeTesters.add(structuralChangeTester);
    }

    protected void removeStructuralChangeTesterInternal(StructuralChangeTesterInternal structuralChangeTester) {
        this.dmrChangeTesters.remove(structuralChangeTester);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addStructuralChangeSegmentTester(StructuralChangeSegmentTester segmentChangeTester) {
        this.segmentChangeTesters.add(segmentChangeTester);
    }

    protected void removeStructuralChangeSegmentTester(StructuralChangeSegmentTester segmentChangeTester) {
        this.segmentChangeTesters.remove(segmentChangeTester);
    }

    @Reference(unbind="-")
    protected void setEMFFormsSegmentResolver(EMFFormsSegmentResolver segmentResolver) {
        this.segmentResolver = segmentResolver;
    }

    public boolean isStructureChanged(VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        if (EAttribute.class.isInstance(notification.getStructuralFeature())) {
            return false;
        }
        if (notification.getRawNotification().isTouch()) {
            return false;
        }
        EList segments = reference.getSegments();
        if (segments.isEmpty()) {
            return this.testOnDmr(reference, domainRootObject, notification);
        }
        return this.testOnSegments(reference, domainRootObject, notification);
    }

    private boolean testOnSegments(VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        EList segments = reference.getSegments();
        boolean relevantChange = false;
        EObject currentDomainObject = domainRootObject;
        int i = 0;
        while (i < segments.size()) {
            EStructuralFeature.Setting setting;
            VDomainModelReferenceSegment segment = (VDomainModelReferenceSegment)segments.get(i);
            StructuralChangeSegmentTester segmentTester = (StructuralChangeSegmentTester)SEGMENTS_RANKING_HELPER.getHighestRankingElement(this.segmentChangeTesters, tester -> tester.isApplicable(segment));
            if (segmentTester == null) {
                this.reportService.report(new AbstractReport(String.format("Structural changes of the DMR: %1$s could not be analyzed because no suitable StructuralChangeSegmentTester was available for segment %2$s.", reference, segment), 2));
                return false;
            }
            try {
                setting = this.segmentResolver.resolveSegment(segment, currentDomainObject);
            }
            catch (DatabindingFailedException ex) {
                this.reportService.report(new AbstractReport((Throwable)ex, "Could not finish structural change calculation."));
                break;
            }
            if ((relevantChange |= segmentTester.isStructureChanged(segment, currentDomainObject, notification)) || !EReference.class.isInstance(setting.getEStructuralFeature())) {
                return relevantChange;
            }
            if (i == segments.size() - 1) break;
            currentDomainObject = (EObject)setting.get(true);
            ++i;
        }
        return relevantChange;
    }

    private boolean testOnDmr(VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        StructuralChangeTesterInternal bestTester = (StructuralChangeTesterInternal)DMR_RANKING_HELPER.getHighestRankingElement(this.dmrChangeTesters, tester -> tester.isApplicable(reference));
        if (bestTester == null) {
            this.reportService.report(new AbstractReport("Structural changes of the DMR: " + reference + "could not be analyzed because no suitable StructuralChangeTesterInternal was available.", 2));
            return false;
        }
        return bestTester.isStructureChanged(reference, domainRootObject, notification);
    }
}

