/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.view.migrator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecp.spi.view.migrator.NameSpaceHandler;
import org.eclipse.emf.ecp.spi.view.migrator.SAXUtil;

public final class ViewNsMigrationUtil {
    private static final Pattern VIEW_NS_URI_PATTERN = Pattern.compile("http://org/eclipse/emf/ecp/view/model(/[0-9]+)?");

    private ViewNsMigrationUtil() {
    }

    public static boolean migrateViewEcoreNsUri(File file) throws IOException {
        return ViewNsMigrationUtil.migrateViewEcoreNsUri(file, file);
    }

    public static boolean checkMigration(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        String templateModelString = ViewNsMigrationUtil.readFile(fileReader);
        fileReader.close();
        String viewNs = ViewNsMigrationUtil.extractViewNsUri(new StringReader(templateModelString));
        String registeredViewNsUri = ViewNsMigrationUtil.getRegisteredViewNsUri();
        boolean needsMigration = ViewNsMigrationUtil.needsMigration(viewNs, registeredViewNsUri);
        return !needsMigration;
    }

    private static boolean needsMigration(String viewNs, String registeredViewNsUri) {
        return viewNs != null && registeredViewNsUri != null && !viewNs.equals(registeredViewNsUri);
    }

    static boolean migrateViewEcoreNsUri(File inputFile, File outputFile) throws IOException {
        FileReader fileReader = new FileReader(inputFile);
        String templateModelString = ViewNsMigrationUtil.readFile(fileReader);
        fileReader.close();
        String viewNs = ViewNsMigrationUtil.extractViewNsUri(new StringReader(templateModelString));
        String registeredViewNsUri = ViewNsMigrationUtil.getRegisteredViewNsUri();
        if (ViewNsMigrationUtil.needsMigration(viewNs, registeredViewNsUri)) {
            String updatedModel = templateModelString.toString().replaceAll(viewNs, registeredViewNsUri);
            FileWriter writer = new FileWriter(outputFile, false);
            writer.write(updatedModel);
            writer.close();
            return true;
        }
        return false;
    }

    private static String readFile(Reader stringReader) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        while ((line = bufferedReader.readLine()) != null) {
            builder.append(line);
            builder.append('\n');
        }
        bufferedReader.close();
        return builder.toString();
    }

    private static String getRegisteredViewNsUri() {
        String registeredViewNsUri = null;
        for (String packageNsUri : EPackage.Registry.INSTANCE.keySet()) {
            Matcher matcher = VIEW_NS_URI_PATTERN.matcher(packageNsUri);
            if (!matcher.matches()) continue;
            registeredViewNsUri = packageNsUri;
            break;
        }
        return registeredViewNsUri;
    }

    private static String extractViewNsUri(Reader reader) throws IOException {
        NameSpaceHandler handler = new NameSpaceHandler();
        SAXUtil.executeContentHandler(reader, handler);
        reader.close();
        List<String> nsURIs = handler.getNsURIs();
        String viewNs = null;
        for (String nsUri : nsURIs) {
            Matcher matcher = VIEW_NS_URI_PATTERN.matcher(nsUri);
            if (!matcher.matches()) continue;
            viewNs = nsUri;
            break;
        }
        return viewNs;
    }
}

