/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt.action;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererViewerActionContext;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DuplicateRowAction
extends TableRendererAction {
    public static final String ACTION_ID = "org.eclipse.emfforms.action.tablecontrol.duplicate_row";
    public static final String DEFAULT_KEYBINDING = "M1+d";

    public DuplicateRowAction(TableRendererViewerActionContext actionContext) {
        super(actionContext);
    }

    public String getId() {
        return ACTION_ID;
    }

    public void execute() {
        EStructuralFeature.Setting setting = this.getActionContext().getSetting();
        EObject eObject = setting.getEObject();
        EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
        List toDuplicate = ((IStructuredSelection)this.getTableViewer().getSelection()).toList();
        Collection<EObject> copies = this.copyElements(eObject, eStructuralFeature, this.getEditingDomainForContainment(), toDuplicate);
        this.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)copies.iterator().next()), true);
    }

    private Collection<EObject> copyElements(EObject eObject, EStructuralFeature structuralFeature, EditingDomain editingDomain, Collection<EObject> elementsToCopy) {
        Collection<EObject> copies = this.copy(elementsToCopy);
        Command createCommand = AddCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, copies);
        if (createCommand.canExecute()) {
            if (editingDomain.getCommandStack() == null) {
                createCommand.execute();
            } else {
                editingDomain.getCommandStack().execute(createCommand);
            }
        }
        return copies;
    }

    Collection<EObject> copy(Collection<EObject> elementsToCopy) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection copies = copier.copyAll(elementsToCopy);
        copier.copyReferences();
        copier.forEach(this::copyBidirectionalReferences);
        return copies;
    }

    private void copyBidirectionalReferences(EObject original, EObject copy) {
        Map find = EcoreUtil.ExternalCrossReferencer.find((EObject)original);
        find.forEach((referenced, settings) -> settings.forEach(setting -> {
            EStructuralFeature feat = setting.getEStructuralFeature();
            EReference opp = ((EReference)feat).getEOpposite();
            if (opp != null && opp.isMany() && setting.getEObject() == original) {
                copy.eSet(feat, setting.get(true));
            }
        }));
    }

    public boolean canExecute() {
        return !this.isTableDisabled() && !this.isUpperBoundReached() && !this.isViewerSelectionInvalid();
    }
}

