/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ecore.editor.ui.operations;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.ecore.editor.IEcoreGenModelLinker;
import org.eclipse.emf.ecp.ecore.editor.factory.EcoreGenModelLinkerFactory;
import org.eclipse.emf.ecp.ecore.editor.util.EcoreGenException;
import org.eclipse.emf.ecp.ecore.editor.util.ProjectHelper;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CreateModelsWorkspaceModifyOperation
extends WorkspaceModifyOperation {
    private final IFile modelFile;
    private final ProjectHelper projectHelper = new ProjectHelper("");
    private final String initialObjectName;
    private final String encoding;
    private final EcorePackage ecorePackage = EcorePackage.eINSTANCE;
    private final EcoreFactory ecoreFactory = this.ecorePackage.getEcoreFactory();

    public CreateModelsWorkspaceModifyOperation(IFile modelFile, String initialObjectName, String encoding, String projectFullName) {
        this.modelFile = modelFile;
        this.initialObjectName = initialObjectName;
        this.encoding = encoding;
        this.projectHelper.setProjectFullName(projectFullName);
    }

    private EObject createInitialModel() {
        EClass eClass = (EClass)this.ecorePackage.getEClassifier(this.initialObjectName);
        EObject rootObject = this.ecoreFactory.create(eClass);
        if (rootObject instanceof ENamedElement) {
            ((ENamedElement)rootObject).setName("");
        }
        return rootObject;
    }

    protected void execute(IProgressMonitor progressMonitor) {
        try {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
                URI fileURI = URI.createPlatformResourceURI((String)this.modelFile.getFullPath().toString(), (boolean)true);
                Resource resource = resourceSet.createResource(fileURI);
                EObject rootObject = this.createInitialModel();
                if (rootObject != null) {
                    resource.getContents().add((Object)rootObject);
                }
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", this.encoding);
                options.put("LINE_DELIMITER", "");
                EcorePackage ecorepack = EcorePackage.eINSTANCE;
                ecorepack = (EPackage)resource.getContents().get(0);
                ecorepack.setName(this.projectHelper.getProjectName());
                ecorepack.setNsPrefix(this.projectHelper.getNSPrefix());
                ecorepack.setNsURI(this.projectHelper.getNSURL());
                resource.save(options);
                IEcoreGenModelLinker linker = EcoreGenModelLinkerFactory.getEcoreGenModelLinker();
                String genModelPath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getFile(this.modelFile.getLocation()).getFullPath().removeLastSegments(1).toOSString()) + "/model.genmodel";
                String ecorePath = this.modelFile.getLocation().toFile().getAbsolutePath();
                String projectPath = "/" + this.modelFile.getLocation().segment(this.modelFile.getLocation().segmentCount() - 3);
                linker.generateGenModel(ecorePath, genModelPath, projectPath);
            }
            catch (EcoreGenException ex) {
                GenModelEditPlugin.INSTANCE.log((Object)ex);
                progressMonitor.done();
            }
            catch (IOException ex) {
                GenModelEditPlugin.INSTANCE.log((Object)ex);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

