/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.workspace.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextAdapter;
import org.eclipse.emf.ecp.spi.core.DefaultProvider;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;
import org.eclipse.emf.ecp.workspace.internal.core.Activator;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;

public class WorkspaceProvider
extends DefaultProvider {
    public static final String NAME = "org.eclipse.emf.ecp.workspace.provider";
    public static final String PROP_ROOT_URI = "rootURI";
    public static final String VIRTUAL_ROOT_URI = "VIRTUAL_URI";
    private static final String COMMAND_MONITORING_ARG = "-monitorCommand";
    private static final String MONITOR_FILTER = WorkspaceProvider.initPackagefilter();
    @Deprecated
    static WorkspaceProvider INSTANCE;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$ecp$spi$core$InternalProvider$LifecycleEvent;

    public WorkspaceProvider() {
        super(NAME);
        INSTANCE = this;
    }

    public void handleLifecycle(ECPContainer context, InternalProvider.LifecycleEvent event) {
        switch (event) {
            case INIT: {
                this.handleInit(context);
                break;
            }
            case DISPOSE: {
                this.handelDispose(context);
                break;
            }
            case CREATE: {
                this.handleCreate(context);
                break;
            }
            case REMOVE: {
                this.handleRemove(context);
                break;
            }
        }
    }

    private void handleInit(ECPContainer context) {
        if (context instanceof InternalProject) {
            InternalProject project = (InternalProject)context;
            EditingDomain editingDomain = project.getEditingDomain();
            editingDomain.getResourceSet().eAdapters().add((Object)new WorkspaceProjectObserver(project, this));
        }
    }

    private void handleRemove(ECPContainer context) {
    }

    private void handleCreate(ECPContainer context) {
    }

    private void handelDispose(ECPContainer context) {
    }

    protected void doDispose() {
        try {
            super.doDispose();
        }
        finally {
            INSTANCE = null;
        }
    }

    public boolean hasCreateRepositorySupport() {
        return false;
    }

    public void fillChildren(ECPContainer context, Object parent, InternalChildrenList childrenList) {
        if (!(parent instanceof ECPRepository)) {
            if (parent instanceof ECPProject) {
                ECPProject project = (ECPProject)parent;
                String rootURI = project.getProperties().getValue(PROP_ROOT_URI);
                ResourceSet resourceSet = project.getEditingDomain().getResourceSet();
                URI uri = URI.createURI((String)rootURI);
                if (uri.hasFragment()) {
                    EObject eObject = resourceSet.getEObject(uri, true);
                    super.fillChildren(context, (Object)eObject, childrenList);
                } else {
                    Resource resource = resourceSet.getResource(uri, true);
                    childrenList.addChildren((Collection)resource.getContents());
                }
            } else {
                super.fillChildren(context, parent, childrenList);
            }
        }
    }

    public EList<? extends Object> getElements(InternalProject project) {
        boolean demandLoad = true;
        if (project.getProperties().getValue(PROP_ROOT_URI).equals(VIRTUAL_ROOT_URI)) {
            demandLoad = false;
        }
        ResourceSet resourceSet = project.getEditingDomain().getResourceSet();
        return resourceSet.getResource(URI.createURI((String)project.getProperties().getValue(PROP_ROOT_URI)), demandLoad).getContents();
    }

    public boolean contains(InternalProject project, Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EObject root = EcoreUtil.getRootContainer((EObject)eObject);
            if (root == null || root.eResource() == null) {
                return false;
            }
            return root.eResource().equals(this.getRoot(project));
        }
        return false;
    }

    public void reload(InternalProject project) {
        EList resources = project.getEditingDomain().getResourceSet().getResources();
        for (Resource resource : resources) {
            if (!resource.equals(this.getRoot(project)) || !resource.isLoaded()) continue;
            resource.unload();
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void cloneProject(InternalProject projectToClone, InternalProject targetProject) {
        throw new UnsupportedOperationException();
    }

    public Notifier getRoot(InternalProject project) {
        boolean demandLoad = true;
        if (project.getProperties().getValue(PROP_ROOT_URI).equals(VIRTUAL_ROOT_URI)) {
            demandLoad = false;
        }
        return project.getEditingDomain().getResourceSet().getResource(URI.createURI((String)project.getProperties().getValue(PROP_ROOT_URI)), demandLoad);
    }

    public void doSave(InternalProject project) {
        try {
            HashMap<String, String> saveOptions = new HashMap<String, String>();
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            EList resources = project.getEditingDomain().getResourceSet().getResources();
            for (Resource resource : resources) {
                resource.save(saveOptions);
            }
            ((BasicCommandStack)project.getEditingDomain().getCommandStack()).saveIsDone();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        super.doSave(project);
    }

    public boolean isDirty(InternalProject project) {
        return ((BasicCommandStack)project.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    public EditingDomain createEditingDomain(InternalProject project) {
        EditingDomain editingDomain = this.isCommandMonitoring() ? this.createMonitoringEditingdomain() : this.createBasicEditingdomain();
        editingDomain.getResourceSet().eAdapters().add((Object)new ECPModelContextAdapter((ECPContainer)project));
        URI uri = URI.createURI((String)project.getProperties().getValue(PROP_ROOT_URI));
        if (project.getProperties().getValue(PROP_ROOT_URI).equals(VIRTUAL_ROOT_URI)) {
            editingDomain.getResourceSet().createResource(uri);
        } else {
            try {
                editingDomain.getResourceSet().getResource(uri, true);
            }
            catch (WrappedException we) {
                project.close();
            }
        }
        return editingDomain;
    }

    private EditingDomain createMonitoringEditingdomain() {
        return new MonitoringEditingDomain();
    }

    private EditingDomain createBasicEditingdomain() {
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)InternalProvider.EMF_ADAPTER_FACTORY, (CommandStack)commandStack);
        return editingDomain;
    }

    private boolean isCommandMonitoring() {
        return !MONITOR_FILTER.isEmpty();
    }

    private static String initPackagefilter() {
        String[] stringArray = Platform.getApplicationArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith(COMMAND_MONITORING_ARG) && arg.length() > COMMAND_MONITORING_ARG.length() && arg.charAt(COMMAND_MONITORING_ARG.length()) == '=') {
                return arg.substring(COMMAND_MONITORING_ARG.length() + 1, arg.length());
            }
            ++n2;
        }
        return "";
    }

    public ECPContainer getModelContext(Object element) {
        return super.getModelContext(element);
    }

    public boolean hasCreateProjectWithoutRepositorySupport() {
        return true;
    }

    public boolean isThreadSafe() {
        return false;
    }

    public void doDelete(InternalProject project, Collection<Object> objects) {
        Command deleteCommand = DeleteCommand.create((EditingDomain)project.getEditingDomain(), objects);
        if (deleteCommand.canExecute()) {
            project.getEditingDomain().getCommandStack().execute(deleteCommand);
            return;
        }
        ChangeCommand changeCommand = new ChangeCommand((Notifier)project.getEditingDomain().getResourceSet()){

            protected void doExecute() {
                for (Object object : objects) {
                    Object unwrap = AdapterFactoryEditingDomain.unwrap(object);
                    if (!EObject.class.isInstance(unwrap)) continue;
                    EcoreUtil.delete((EObject)((EObject)EObject.class.cast(unwrap)), (boolean)true);
                }
            }
        };
        if (changeCommand.canExecute()) {
            project.getEditingDomain().getCommandStack().execute((Command)changeCommand);
            return;
        }
        throw new IllegalStateException("Delete was not successful.");
    }

    static /* synthetic */ void access$0(WorkspaceProvider workspaceProvider, Notification notification) {
        workspaceProvider.notifyProviderChangeListeners(notification);
    }

    static /* synthetic */ String access$1() {
        return MONITOR_FILTER;
    }

    private static class MonitoringChangeRecorder
    extends TransactionChangeRecorder {
        private final Map<String, Object> methodToStack = new HashMap<String, Object>();

        MonitoringChangeRecorder(InternalTransactionalEditingDomain domain, ResourceSet rset) {
            super(domain, rset);
        }

        protected void assertWriting() {
            List<StackTraceElement> stes = Arrays.asList(Thread.currentThread().getStackTrace());
            boolean commandInStack = false;
            for (StackTraceElement ste : stes) {
                try {
                    Class<?> callerClass = Class.forName(ste.getClassName());
                    if (!Command.class.isAssignableFrom(callerClass)) continue;
                    commandInStack = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (!commandInStack) {
                String key;
                List<StackTraceElement> reduced = this.compactStack(stes, 6);
                String string = key = !reduced.isEmpty() ? reduced.get(0).toString() : null;
                if (key != null && !this.methodToStack.containsKey(key)) {
                    this.methodToStack.put(key, reduced);
                    this.log(reduced);
                }
            }
        }

        private String prettyPrintStack(List<StackTraceElement> reduced) {
            StringBuffer buf = new StringBuffer();
            buf.append("[Monitor]: ");
            for (StackTraceElement e : reduced) {
                buf.append(e);
                buf.append(" <- ");
            }
            buf.append("[...]\n");
            return buf.toString();
        }

        private void log(List<StackTraceElement> reduced) {
            Activator.log(this.prettyPrintStack(reduced));
        }

        private List<StackTraceElement> compactStack(List<StackTraceElement> stes, int max) {
            ArrayList<StackTraceElement> compact = new ArrayList<StackTraceElement>(max);
            int i = 0;
            for (StackTraceElement e : stes) {
                if (!e.getClassName().startsWith(MONITOR_FILTER)) continue;
                compact.add(e);
                if (++i == max) break;
            }
            return compact;
        }
    }

    private static class MonitoringEditingDomain
    extends TransactionalEditingDomainImpl {
        MonitoringEditingDomain() {
            super((AdapterFactory)InternalProvider.EMF_ADAPTER_FACTORY);
        }

        protected TransactionChangeRecorder createChangeRecorder(ResourceSet rset) {
            return new MonitoringChangeRecorder((InternalTransactionalEditingDomain)this, rset);
        }
    }

    private class WorkspaceProjectObserver
    extends EContentAdapter {
        private final InternalProject project;
        private final WorkspaceProvider provider;

        WorkspaceProjectObserver(InternalProject project, WorkspaceProvider provider) {
            this.project = project;
            this.provider = provider;
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getNotifier() instanceof EObject) {
                EReference eReference;
                this.provider.notifyProviderChangeListeners(notification);
                EObject eObject = (EObject)notification.getNotifier();
                this.project.notifyObjectsChanged(Collections.singleton(eObject), false);
                Object feature = notification.getFeature();
                if (feature instanceof EReference && (eReference = (EReference)feature).isContainment() && notification.getNewValue() instanceof EObject) {
                    this.project.notifyObjectsChanged(Collections.singleton(notification.getNewValue()), true);
                }
            }
        }
    }
}

