/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.internal.editor.controls.ECPSelectionStatusValidator;
import org.eclipse.emf.ecp.view.internal.editor.controls.EditableEReferenceLabelControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.editor.controls.AbstractFilteredReferenceCommand;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;

public class LinkFeatureControlRenderer
extends EditableEReferenceLabelControlSWTRenderer {
    @Inject
    public LinkFeatureControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    @Override
    protected void linkValue(Shell shell) {
        EObject eObject;
        try {
            eObject = this.getEObject();
        }
        catch (DatabindingFailedException ex) {
            this.showLinkValueFailedMessageDialog(shell, (Exception)((Object)ex));
            return;
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        FilteredReferenceCommand referenceCommand = new FilteredReferenceCommand((Notifier)eObject, adapterFactory, shell);
        if (referenceCommand.canExecute()) {
            referenceCommand.execute();
        }
    }

    private EObject getEObject() throws DatabindingFailedException {
        IObservableValue observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        return (EObject)((IObserving)observableValue).getObserved();
    }

    protected EClass getRootEClass(Notifier notifier) {
        return Helper.getRootEClass((EObject)notifier);
    }

    private class FilteredReferenceCommand
    extends AbstractFilteredReferenceCommand<EStructuralFeature> {
        FilteredReferenceCommand(Notifier notifier, ComposedAdapterFactory composedAdapterFactory, Shell shell) {
            super(notifier, composedAdapterFactory, shell, LinkFeatureControlRenderer.this.getRootEClass(notifier), new ECPSelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length != 0 && EStructuralFeature.class.isInstance(selection[0])) {
                        TreePath treePath = this.getTreePath();
                        if (!Helper.hasFeaturePropertyDescriptor(((EStructuralFeature)EStructuralFeature.class.cast(selection[0])).getEContainingClass(), treePath)) {
                            return new Status(2, "org.eclipse.emf.ecp.view.editor.controls", "The selected " + EStructuralFeature.class.getSimpleName() + " has no PropertyDescriptor.");
                        }
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.emf.ecp.view.editor.controls", "This is not an " + EStructuralFeature.class.getSimpleName() + ".");
                }
            }, false);
        }

        @Override
        protected void setSelectedValues(EStructuralFeature selectedFeature, List<EReference> bottomUpPath) {
            try {
                VFeaturePathDomainModelReference modelReference = (VFeaturePathDomainModelReference)LinkFeatureControlRenderer.this.getEObject();
                modelReference.setDomainModelEFeature(selectedFeature);
                modelReference.getDomainModelEReferencePath().clear();
                modelReference.getDomainModelEReferencePath().addAll(bottomUpPath);
            }
            catch (DatabindingFailedException ex) {
                Activator.getDefault().getReportService().report(new AbstractReport((Throwable)ex));
            }
        }
    }
}

