/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.workspace.migrator;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrator;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigratorUtil;
import org.eclipse.emf.ecp.view.migrator.ViewModelWorkspaceMigrator;

public final class ViewModelWorkspaceMigratorService
implements ViewModelWorkspaceMigrator {
    private static ViewModelMigrator viewModelMigrator;

    public ArrayList<URI> getURIsToMigrate() throws CoreException {
        ArrayList<URI> urisToMigrate = new ArrayList<URI>();
        if (ViewModelWorkspaceMigratorService.getViewModelMigrator() == null) {
            return urisToMigrate;
        }
        List<URI> viewModelURIs = ViewModelWorkspaceMigratorService.getViewModelURIsInWorkspace();
        for (URI viewModel : viewModelURIs) {
            if (viewModelMigrator.checkMigration(viewModel)) continue;
            urisToMigrate.add(viewModel);
        }
        return urisToMigrate;
    }

    private static ViewModelMigrator getViewModelMigrator() {
        if (viewModelMigrator == null) {
            viewModelMigrator = ViewModelMigratorUtil.getViewModelMigrator();
        }
        return viewModelMigrator;
    }

    private static List<URI> getViewModelURIsInWorkspace() throws CoreException {
        final ArrayList<URI> uris = new ArrayList<URI>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.getRoot().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getFileExtension() != null && resource.getFileExtension().equals("view")) {
                    try {
                        uris.add(URI.createURI((String)resource.getLocationURI().toURL().toExternalForm()));
                    }
                    catch (MalformedURLException ex) {
                        return false;
                    }
                }
                return resource.getType() != 1;
            }
        });
        return uris;
    }
}

