/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.internal.editor.controls.ExpectedValueControlRenderer;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateDomainModelReferenceWizard;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.eclipse.emf.ecp.view.spi.rule.model.impl.LeafConditionImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LeafConditionControlRenderer
extends ExpectedValueControlRenderer {
    @Inject
    public LeafConditionControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    @Override
    protected void onSelectButton(Label control) {
        LeafCondition condition;
        try {
            condition = (LeafCondition)this.getObservedEObject();
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        if (condition.getDomainModelReference() == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No Feature Path Domain Model Reference found", (String)"A Feature Path Domain Model Reference needs to be added to the condition first. ");
            return;
        }
        EStructuralFeature structuralFeature = ((VFeaturePathDomainModelReference)condition.getDomainModelReference()).getDomainModelEFeature();
        if (structuralFeature == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No value selected", (String)"Please set a value to the Domain Model Reference first. ");
            return;
        }
        if (EReference.class.isInstance(structuralFeature)) {
            EReference reference = (EReference)EReference.class.cast(structuralFeature);
            EClass referenceType = reference.getEReferenceType();
            Collection dmrEClasses = ECPUtil.getSubClasses((EClass)VViewPackage.eINSTANCE.getDomainModelReference());
            EStructuralFeature.Setting valueDMRSeting = ((LeafConditionImpl)condition).eSetting((EStructuralFeature)RulePackage.eINSTANCE.getLeafCondition_ValueDomainModelReference());
            CreateDomainModelReferenceWizard dmrWizard = new CreateDomainModelReferenceWizard(valueDMRSeting, this.getEditingDomain(valueDMRSeting.getEObject()), referenceType, "New Domain Model Reference", "New value reference", "New value reference", "Select the attribute to be tested.", null);
            SelectionComposite compositeProvider = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), (Collection)dmrEClasses);
            dmrWizard.setCompositeProvider((CompositeProvider)compositeProvider);
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)dmrWizard);
            wizardDialog.open();
        }
        if (condition.getValueDomainModelReference() != null) {
            structuralFeature = ((VFeaturePathDomainModelReference)condition.getValueDomainModelReference()).getDomainModelEFeature();
        }
        if (EReference.class.isInstance(structuralFeature)) {
            return;
        }
        Object object = this.getSelectedObject((EAttribute)structuralFeature);
        if (object != null) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)condition);
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)condition, (Object)RulePackage.eINSTANCE.getLeafCondition_ExpectedValue(), (Object)object));
            control.setText(object.toString());
        }
    }
}

