/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emfforms.common.Feature;
import org.eclipse.emfforms.spi.swt.table.AbstractFeatureAwareBuilder;
import org.eclipse.emfforms.spi.swt.table.TableConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableConfigurationImpl;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTBuilder;

public final class TableConfigurationBuilder
extends AbstractFeatureAwareBuilder<TableConfigurationBuilder> {
    private final Set<Feature> features;
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();

    private TableConfigurationBuilder() {
        this(new LinkedHashSet<Feature>());
    }

    private TableConfigurationBuilder(Set<Feature> features) {
        this.features = features;
    }

    public static TableConfigurationBuilder usingDefaults() {
        return new TableConfigurationBuilder();
    }

    static TableConfigurationBuilder withFeatures(Collection<Feature> features) {
        return new TableConfigurationBuilder(Feature.inherit(features, TableConfiguration.ALL_FEATURES::contains));
    }

    public static TableConfigurationBuilder usingConfiguration(TableConfiguration tableConfiguration) {
        return new TableConfigurationBuilder(tableConfiguration);
    }

    public static TableConfigurationBuilder from(TableViewerSWTBuilder viewerBuilder) {
        return TableConfigurationBuilder.withFeatures(viewerBuilder.getEnabledFeatures());
    }

    private TableConfigurationBuilder(TableConfiguration tableConfiguration) {
        this(tableConfiguration.getEnabledFeatures());
    }

    @Override
    @Deprecated
    public Set<Feature> getSupportedFeatures() {
        return new LinkedHashSet<Feature>(TableConfiguration.ALL_FEATURES);
    }

    @Override
    @Deprecated
    protected Set<Feature> getEnabledFeatures() {
        return this.features;
    }

    public TableConfigurationBuilder showHideColumns(boolean showHideColumns) {
        return showHideColumns ? (TableConfigurationBuilder)this.enableFeature(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW) : (TableConfigurationBuilder)this.disableFeature(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW);
    }

    public TableConfigurationBuilder columnSubstringFilter(boolean columnSubstringFilter) {
        return columnSubstringFilter ? (TableConfigurationBuilder)this.enableFeature(TableConfiguration.FEATURE_COLUMN_FILTER) : (TableConfigurationBuilder)this.disableFeature(TableConfiguration.FEATURE_COLUMN_FILTER);
    }

    public TableConfigurationBuilder columnRegexFilter(boolean columnRegexFilter) {
        return columnRegexFilter ? (TableConfigurationBuilder)this.enableFeature(TableConfiguration.FEATURE_COLUMN_REGEX_FILTER) : (TableConfigurationBuilder)this.disableFeature(TableConfiguration.FEATURE_COLUMN_REGEX_FILTER);
    }

    public TableConfigurationBuilder dataMapEntry(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public TableConfiguration build() {
        TableConfigurationImpl config = new TableConfigurationImpl(this.features, this.data);
        return config;
    }
}

