/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.core.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextProvider;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.emfstore.core.internal.Activator;
import org.eclipse.emf.ecp.emfstore.core.internal.ECPEMFUtils;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProjectWrapper;
import org.eclipse.emf.ecp.spi.core.DefaultProvider;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreClientUtil;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.observers.OperationObserver;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public final class EMFStoreProvider
extends DefaultProvider {
    public static final String NAME = "org.eclipse.emf.ecp.emfstore.provider";
    @Deprecated
    public static EMFStoreProvider INSTANCE;
    public static final String PROP_REPOSITORY_URL = "repositoryUrl";
    public static final String PROP_PORT = "port";
    public static final String PROP_CERTIFICATE = "certificate";
    public static final String PROP_PROJECTSPACEID = "projectSpaceID";
    public static final String PROP_SERVERINFOID = "serverInfoID";
    private AdapterImpl adapter;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$ecp$spi$core$InternalProvider$LifecycleEvent;

    public EMFStoreProvider() {
        super(NAME);
        this.configureEMFStore();
        INSTANCE = this;
    }

    private void configureEMFStore() {
        Configuration.getClientBehavior().setAutoSave(false);
    }

    public EditingDomain createEditingDomain(InternalProject project) {
        EditingDomain domain = ((Workspace)ECPEMFUtils.getESWorkspaceProviderInstance().getWorkspace().toInternalAPI()).getEditingDomain();
        return domain;
    }

    public void fillChildren(ECPContainer context, Object parent, InternalChildrenList childrenList) {
        ESServer serverInfo;
        if (parent instanceof InternalProject) {
            ESLocalProject projectSpace = this.getProjectSpace((InternalProject)parent);
            if (projectSpace != null) {
                childrenList.addChildren((Collection)projectSpace.getModelElements());
            }
        } else if (parent instanceof InternalRepository && (serverInfo = this.getServerInfo((InternalRepository)parent)).getLastUsersession() != null && serverInfo.getLastUsersession().isLoggedIn()) {
            try {
                List projectInfos = serverInfo.getRemoteProjects(serverInfo.getLastUsersession());
                for (ESRemoteProject projectInfo : projectInfos) {
                    childrenList.addChild((Object)new EMFStoreProjectWrapper((InternalRepository)parent, projectInfo));
                }
            }
            catch (ESException e) {
                Activator.log(e);
            }
        }
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                EMFStoreProvider.super.fillChildren(context, parent, childrenList);
                return null;
            }
        });
    }

    public boolean hasCreateProjectWithoutRepositorySupport() {
        return true;
    }

    public EList<? extends Object> getElements(InternalProject project) {
        return this.getProjectSpace(project).getModelElements();
    }

    public void handleLifecycle(ECPContainer context, InternalProvider.LifecycleEvent event) {
        switch (event) {
            case INIT: {
                this.handleInit(context);
                break;
            }
            case DISPOSE: {
                this.handelDispose(context);
                break;
            }
            case CREATE: {
                this.handleCreate(context);
                break;
            }
            case REMOVE: {
                this.handleRemove(context);
                break;
            }
        }
        String providerClass = ((Object)((Object)this)).getClass().getSimpleName();
        String contextClass = context.getClass().getSimpleName();
        Activator.log(1, String.valueOf(providerClass) + " received " + event + " for " + contextClass + " " + context);
    }

    private void handleRemove(ECPContainer context) {
        InternalProject project;
        ESLocalProject ps;
        if (context instanceof InternalProject && (ps = (ESLocalProject)(project = (InternalProject)context).getProviderSpecificData()) != null) {
            try {
                ps.delete((IProgressMonitor)new NullProgressMonitor());
            }
            catch (ESException ex) {
                Activator.log(ex);
            }
            catch (IOException ex) {
                Activator.log(ex);
            }
            project.setProviderSpecificData(null);
        }
    }

    private void handleCreate(ECPContainer context) {
        if (context instanceof InternalRepository) {
            this.getServerInfo((InternalRepository)context);
        } else if (context instanceof InternalProject) {
            this.getProjectSpace((InternalProject)context);
        }
    }

    private void handelDispose(ECPContainer context) {
        ESLocalProject projectSpace;
        if (context instanceof InternalProject && (projectSpace = this.getProjectSpace((InternalProject)context)) != null) {
            ((ProjectSpace)((ESLocalProjectImpl)projectSpace).toInternalAPI()).getProject().eAdapters().remove((Object)this.adapter);
        }
    }

    private boolean isAutosave() {
        IPreferencesService service = Platform.getPreferencesService();
        return service.getBoolean("org.eclipse.emf.ecp", "AUTOSAVE", false, null);
    }

    private void handleInit(ECPContainer context) {
        if (context instanceof InternalProject) {
            ESLocalProject localProject = this.getProjectSpace((InternalProject)context, true);
            if (localProject == null) {
                return;
            }
            ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
            if (this.isAutosave()) {
                projectSpace.getOperationManager().addOperationObserver(new OperationObserver(){

                    public void operationUndone(AbstractOperation operation) {
                        EMFStoreProvider.this.doSave((InternalProject)context);
                    }

                    public void operationExecuted(AbstractOperation operation) {
                        EMFStoreProvider.this.doSave((InternalProject)context);
                    }
                });
            }
            projectSpace.getProject().addIdEObjectCollectionChangeObserver(new IdEObjectCollectionChangeObserver(){

                public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
                    EMFStoreProvider.this.notifyProviderChangeListeners(notification);
                    if (modelElement instanceof ProjectImpl) {
                        ProjectSpaceImpl projectSpace = (ProjectSpaceImpl)modelElement.eContainer();
                        ECPProject ecpProject = EMFStoreProvider.this.getProject((ESLocalProject)projectSpace.toAPI());
                        ((InternalProject)context).notifyObjectsChanged(Collections.singleton(ecpProject), true);
                    } else {
                        ((InternalProject)context).notifyObjectsChanged(Collections.singleton(modelElement), true);
                    }
                }

                public void modelElementRemoved(IdEObjectCollection collection, EObject modelElement) {
                    if (modelElement.eContainer() == null) {
                        ((InternalProject)context).notifyObjectsChanged(Arrays.asList(context, modelElement), true);
                    }
                }

                public void modelElementAdded(IdEObjectCollection collection, EObject modelElement) {
                    if (Project.class.isInstance(modelElement.eContainer())) {
                        ((InternalProject)context).notifyObjectsChanged(Arrays.asList(modelElement, context), true);
                    }
                    ((InternalProject)context).notifyObjectsChanged(Collections.singleton(modelElement), true);
                }

                public void collectionDeleted(IdEObjectCollection collection) {
                    ((InternalProject)context).notifyObjectsChanged(Collections.singleton(context), true);
                }
            });
        }
    }

    public Iterator<EObject> getLinkElements(InternalProject project, EObject modelElement, EReference eReference) {
        HashSet result = new HashSet();
        EClass elementClass = modelElement.eClass();
        EClassifier type = EcoreUtil.getReifiedType((EClass)elementClass, (EGenericType)eReference.getEGenericType()).getEClassifier();
        if (type == null) {
            type = eReference.getEType();
        }
        ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)this.getProjectSpace(project)).toInternalAPI();
        ItemPropertyDescriptor.collectReachableObjectsOfType(new HashSet(), result, (EObject)projectSpace.getProject(), (EClassifier)type);
        return result.iterator();
    }

    private boolean isSameServerInfo(ESServer info, String url, int port, String certificate) {
        return info.getURL().equalsIgnoreCase(url) && info.getPort() == port && info.getCertificateAlias().equalsIgnoreCase(certificate);
    }

    public void doSave(InternalProject project) {
        this.getProjectSpace(project).save();
    }

    public boolean isDirty(InternalProject project) {
        return this.getProjectSpace(project).hasUnsavedChanges();
    }

    public void cloneProject(InternalProject projectToClone, InternalProject targetProject) {
        ProjectSpace toClone = (ProjectSpace)((ESLocalProjectImpl)this.getProjectSpace(projectToClone)).toInternalAPI();
        ProjectSpace target = (ProjectSpace)((ESLocalProjectImpl)this.getProjectSpace(targetProject)).toInternalAPI();
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                target.setProject((Project)ModelUtil.clone((EObject)toClone.getProject()));
            }
        });
    }

    public boolean modelExists(InternalProject project) {
        return this.getProjectSpace(project, false) != null;
    }

    public Notifier getRoot(InternalProject project) {
        return ((ProjectSpace)((ESLocalProjectImpl)this.getProjectSpace(project)).toInternalAPI()).getProject();
    }

    public boolean contains(InternalProject project, Object object) {
        if (!EObject.class.isInstance(object)) {
            return false;
        }
        ESLocalProject projectSpace = this.getProjectSpace(project);
        return projectSpace.contains((EObject)object);
    }

    public ECPContainer getModelContext(Object element) {
        ResourceSet resourceSet;
        ECPContainer context;
        if (element instanceof ECPContainer) {
            return (ECPContainer)element;
        }
        if (element instanceof ECPModelContextProvider) {
            return ((ECPModelContextProvider)element).getModelContext(element);
        }
        if (element instanceof EObject) {
            ECPContainer context2;
            EObject eObject = (EObject)element;
            ProjectSpace ps = null;
            try {
                ps = ESWorkspaceProviderImpl.getProjectSpace((EObject)eObject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            if (ps != null && (context2 = this.getModelContextFromAdapter((Notifier)ps.getProject())) != null) {
                return context2;
            }
            element = eObject.eResource();
        }
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            context = this.getModelContextFromAdapter((Notifier)resource);
            if (context != null) {
                return context;
            }
            element = resource.getResourceSet();
        }
        if (element instanceof ResourceSet && (context = this.getModelContextFromAdapter((Notifier)(resourceSet = (ResourceSet)element))) != null) {
            return context;
        }
        return null;
    }

    public ESLocalProject getProjectSpace(InternalProject internalProject) {
        return this.getProjectSpace(internalProject, false);
    }

    private ESLocalProject getProjectSpace(InternalProject internalProject, boolean createNewIfNeeded) {
        ESLocalProject projectSpace = (ESLocalProject)internalProject.getProviderSpecificData();
        if (projectSpace == null) {
            boolean found = false;
            List localProjects = ECPEMFUtils.getESWorkspaceProviderInstance().getWorkspace().getLocalProjects();
            for (ESLocalProject localProject : localProjects) {
                String projectSpaceID = internalProject.getProperties().getValue(PROP_PROJECTSPACEID);
                if (!localProject.getLocalProjectId().getId().equals(projectSpaceID)) continue;
                found = true;
                projectSpace = localProject;
                break;
            }
            if (!found && createNewIfNeeded) {
                projectSpace = ECPEMFUtils.getESWorkspaceProviderInstance().getWorkspace().createLocalProject(internalProject.getName());
                internalProject.getProperties().addProperty(PROP_PROJECTSPACEID, projectSpace.getLocalProjectId().getId());
            }
            internalProject.setProviderSpecificData((Object)projectSpace);
        }
        return projectSpace;
    }

    public ESServer getServerInfo(InternalRepository internalRepository) {
        ESServer serverInfo = (ESServer)internalRepository.getProviderSpecificData();
        if (serverInfo == null) {
            ESWorkspaceImpl workspace = ECPEMFUtils.getESWorkspaceProviderInstance().getWorkspace();
            boolean foundExisting = false;
            for (ESServer info : workspace.getServers()) {
                if (!internalRepository.getProperties().hasProperties() || !this.isSameServerInfo(info, internalRepository.getProperties().getValue(PROP_REPOSITORY_URL), Integer.parseInt(internalRepository.getProperties().getValue(PROP_PORT)), internalRepository.getProperties().getValue(PROP_CERTIFICATE))) continue;
                serverInfo = info;
                foundExisting = true;
                break;
            }
            if (!foundExisting && internalRepository.getProperties().hasProperties()) {
                serverInfo = (ESServer)EMFStoreClientUtil.createServerInfo((String)internalRepository.getProperties().getValue(PROP_REPOSITORY_URL), (int)Integer.parseInt(internalRepository.getProperties().getValue(PROP_PORT)), (String)internalRepository.getProperties().getValue(PROP_CERTIFICATE)).toAPI();
                workspace.addServer(serverInfo);
            } else if (!foundExisting && !internalRepository.getProperties().hasProperties()) {
                serverInfo = (ESServer)EMFStoreClientUtil.giveServerInfo((String)"localhost", (int)8080).toAPI();
            }
            internalRepository.setProviderSpecificData((Object)serverInfo);
        }
        return serverInfo;
    }

    public ECPProject getProject(ESLocalProject projectSpace) {
        for (InternalProject project : this.getOpenProjects()) {
            ESLocalProject localProjectSpace = (ESLocalProject)project.getProviderSpecificData();
            if (!localProjectSpace.equals(projectSpace)) continue;
            return project;
        }
        return null;
    }

    public ECPRepository getRepository(ESServer serverInfo) {
        if (serverInfo != null) {
            for (ECPRepository internalRepository : ECPUtil.getECPRepositoryManager().getRepositories()) {
                if (!internalRepository.getProvider().equals((Object)this) || !serverInfo.equals(((InternalRepository)internalRepository).getProviderSpecificData())) continue;
                return internalRepository;
            }
        }
        return null;
    }

    public boolean isThreadSafe() {
        return false;
    }

    public void doDelete(InternalProject project, Collection<Object> objects) {
        ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)this.getProjectSpace(project)).toInternalAPI();
        new EMFStoreCommand(){

            protected void doRun() {
                for (Object object : objects) {
                    if (!EObject.class.isInstance(object)) continue;
                    projectSpace.getProject().deleteModelElement((EObject)object);
                }
            }
        }.run(false);
    }

    static /* synthetic */ void access$0(EMFStoreProvider eMFStoreProvider, ECPContainer eCPContainer, Object object, InternalChildrenList internalChildrenList) {
        super.fillChildren(eCPContainer, object, internalChildrenList);
    }

    static /* synthetic */ void access$2(EMFStoreProvider eMFStoreProvider, Notification notification) {
        eMFStoreProvider.notifyProviderChangeListeners(notification);
    }
}

