/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emfforms.internal.editor.ecore.actions.CreateNewInstaceWizard;
import org.eclipse.emfforms.spi.swt.treemasterdetail.actions.MasterDetailAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class CreateNewInstanceAction
extends MasterDetailAction {
    private static final String ICON_PATH = "icons/EcoreModelFile.gif";
    private static final String ACTION_NAME = "Create New Dynamic Instance";

    public CreateNewInstanceAction() {
        this.setLabel(ACTION_NAME);
        this.setImagePath(ICON_PATH);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    public boolean shouldShow(EObject eObject) {
        return EClass.class.isInstance(eObject);
    }

    public void execute(EObject object) {
        EClass eClass = (EClass)EClass.class.cast(object);
        Diagnostic validate = Diagnostician.INSTANCE.validate((EObject)eClass);
        if (validate.getSeverity() == 0) {
            CreateNewInstaceWizard wizard = new CreateNewInstaceWizard(eClass);
            new WizardDialog(this.getTreeViewer().getTree().getShell(), (IWizard)wizard).open();
        } else {
            MultiStatus status = new MultiStatus("org.eclipse.emfforms.editor.ecore", 4, "Can not create a new instance file for EClass " + eClass.getName() + " because it is invalid.", null);
            for (Diagnostic d : validate.getChildren()) {
                status.add((IStatus)new Status(4, "org.eclipse.emfforms.editor.ecore", d.getMessage()));
            }
            ErrorDialog.openError((Shell)this.getTreeViewer().getTree().getShell(), (String)"Error", null, (IStatus)status);
        }
    }
}

