/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.changebroker.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.changebroker.internal.Strategy;
import org.eclipse.emf.ecp.changebroker.spi.EMFObserver;

public class FeatureStrategy
implements Strategy {
    private final Map<EStructuralFeature, Set<EMFObserver>> registry = new LinkedHashMap<EStructuralFeature, Set<EMFObserver>>();
    private final Map<EMFObserver, Set<EStructuralFeature>> observerToKey = new LinkedHashMap<EMFObserver, Set<EStructuralFeature>>();

    public void register(EMFObserver observer, EStructuralFeature feature) {
        if (!this.registry.containsKey(feature)) {
            this.registry.put(feature, new LinkedHashSet());
        }
        this.registry.get(feature).add(observer);
        if (!this.observerToKey.containsKey(observer)) {
            this.observerToKey.put(observer, new LinkedHashSet());
        }
        this.observerToKey.get(observer).add(feature);
    }

    @Override
    public Set<EMFObserver> getObservers(Notification notification) {
        Object feature = notification.getFeature();
        if (!this.registry.containsKey(feature)) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<EMFObserver>((Collection)this.registry.get(feature));
    }

    @Override
    public void deregister(EMFObserver observer) {
        Set<EStructuralFeature> keys = this.observerToKey.remove(observer);
        if (keys == null) {
            return;
        }
        for (EStructuralFeature feature : keys) {
            Set<EMFObserver> set = this.registry.get(feature);
            set.remove(observer);
            if (!set.isEmpty()) continue;
            this.registry.remove(feature);
        }
    }

    @Override
    public Set<EMFObserver> getAllObservers() {
        return new LinkedHashSet<EMFObserver>(this.observerToKey.keySet());
    }
}

