/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.history.instantiation.ReleaseCommand;
import org.eclipse.emf.edapt.history.instantiation.UpdatePackageNamespaceCommand;
import org.eclipse.emf.edapt.history.instantiation.ui.EditingDomainListenerHandlerBase;
import org.eclipse.emf.edapt.history.instantiation.ui.ReleaseDialog;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.recorder.EditingDomainListener;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseHandler
extends EditingDomainListenerHandlerBase {
    @Override
    protected Object execute(EditingDomainListener listener, EcoreEditor editor) {
        MetamodelExtent extent = listener.getExtent();
        if (this.isConsistent(extent)) {
            this.release(extent, listener);
        }
        return null;
    }

    private boolean isConsistent(MetamodelExtent extent) {
        if (extent.isConsistent()) {
            return true;
        }
        boolean ignore = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Metamodel inconsistent", (String)"The metamodel is inconsistent. Do you really want to release it?");
        return ignore;
    }

    private void release(MetamodelExtent extent, EditingDomainListener listener) {
        EditingDomain domain = listener.getEditingDomain();
        if (!this.isNsURIChanged(extent, listener.getHistory().getLastRelease())) {
            History history = listener.getHistory();
            EList rootPackages = history.getRootPackages();
            String source = this.inferSource((List<EPackage>)rootPackages);
            ReleaseDialog dialog = new ReleaseDialog(source);
            if (dialog.open() == 0) {
                String target = dialog.getTarget();
                if (dialog.isUpdate()) {
                    this.updateNamespaceURI(domain, (List<EPackage>)rootPackages, dialog.getSource(), target);
                    if (this.isNsURIChanged(extent, history.getLastRelease())) {
                        this.addRelease(domain, listener, target);
                    } else {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Namepaces URIs not fully changed since last release");
                    }
                } else {
                    this.addRelease(domain, listener, target);
                }
            }
        } else {
            this.addRelease(domain, listener, null);
        }
    }

    private String inferSource(List<EPackage> ePackages) {
        try {
            String nsURI = ePackages.get(0).getNsURI();
            int index = nsURI.lastIndexOf(47);
            return nsURI.substring(index + 1);
        }
        catch (RuntimeException runtimeException) {
            return "";
        }
    }

    private void updateNamespaceURI(EditingDomain domain, List<EPackage> rootPackages, String source, String target) {
        UpdatePackageNamespaceCommand command = new UpdatePackageNamespaceCommand(rootPackages, source, target);
        domain.getCommandStack().execute((Command)command);
    }

    private void addRelease(EditingDomain domain, EditingDomainListener listener, String target) {
        ReleaseCommand command = new ReleaseCommand(listener, target);
        domain.getCommandStack().execute((Command)command);
    }

    private boolean isNsURIChanged(MetamodelExtent extent, Release release) {
        EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(URI.createURI((String)"before"));
        reconstructor.reconstruct(release, true);
        return this.isNsURIChanged(extent.getRootPackages(), reconstructor);
    }

    private boolean isNsURIChanged(Collection<EPackage> packages, EcoreForwardReconstructor reconstructor) {
        for (EPackage now : packages) {
            EPackage before = (EPackage)reconstructor.getMapping().getTarget((EObject)now);
            if (before != null && now.getNsURI().equals(before.getNsURI())) {
                return false;
            }
            if (this.isNsURIChanged((Collection<EPackage>)now.getESubpackages(), reconstructor)) continue;
            return false;
        }
        return true;
    }
}

