/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.descriptor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.config.descriptor.impl.ArquillianDescriptorImpl;
import org.jboss.arquillian.config.descriptor.impl.ProtocolDefImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

public class ContainerDefImpl
extends ArquillianDescriptorImpl
implements ContainerDef {
    private Node container;

    public ContainerDefImpl(String descriptorName) {
        this(descriptorName, new Node("arquillian"));
    }

    public ContainerDefImpl(String descriptorName, Node model) {
        this(descriptorName, model, model.createChild("container"));
    }

    public ContainerDefImpl(String descriptorName, Node model, Node container) {
        super(descriptorName, model);
        this.container = container;
    }

    public ContainerDef setContainerName(String name) {
        this.container.attribute("qualifier", name);
        return this;
    }

    public String getContainerName() {
        return this.container.getAttribute("qualifier");
    }

    public ContainerDef setDefault() {
        this.container.attribute("default", (Object)true);
        return this;
    }

    public boolean isDefault() {
        return Boolean.parseBoolean(this.container.getAttribute("default"));
    }

    public ContainerDef setMode(String mode) {
        this.container.attribute("mode", mode);
        return this;
    }

    public String getMode() {
        return this.container.getAttribute("mode") == null ? "suite" : this.container.getAttribute("mode");
    }

    public ContainerDef dependency(String artifactId) {
        this.container.getOrCreate("dependencies").getOrCreate("dependency=" + artifactId);
        return this;
    }

    public ProtocolDef protocol(String type) {
        return new ProtocolDefImpl(this.getDescriptorName(), this.getRootNode(), this.container, this.container.getOrCreate("protocol@type=" + type));
    }

    public ContainerDef property(String name, String value) {
        this.container.getOrCreate("configuration").getOrCreate("property@name=" + name).text(value);
        return this;
    }

    public ContainerDef overrideProperty(String name, String value) {
        this.container.getOrCreate("configuration").removeChild("property@name=" + name);
        this.container.getOrCreate("configuration").getOrCreate("property@name=" + name).text(value);
        return this;
    }

    public Map<String, String> getContainerProperties() {
        Node props = this.container.getSingle("configuration");
        HashMap<String, String> properties = new HashMap<String, String>();
        if (props != null) {
            for (Node prop : props.get("property")) {
                properties.put(prop.getAttribute("name"), prop.getText());
            }
        }
        return properties;
    }

    public String getContainerProperty(String name) {
        Node props = this.container.getSingle("configuration");
        if (props != null) {
            Node value = props.getSingle("property@name=" + name);
            return value != null ? value.getText() : null;
        }
        return null;
    }

    public List<ProtocolDef> getProtocols() {
        ArrayList<ProtocolDef> protocols = new ArrayList<ProtocolDef>();
        for (Node proto : this.container.get("protocol")) {
            protocols.add(new ProtocolDefImpl(this.getDescriptorName(), this.getRootNode(), this.container, proto));
        }
        return protocols;
    }

    public List<String> getDependencies() {
        ArrayList<String> dependencies = new ArrayList<String>();
        if (this.container.getSingle("dependencies") != null) {
            for (Node dep : this.container.getSingle("dependencies").get("dependency")) {
                dependencies.add(dep.getText());
            }
        }
        return dependencies;
    }

    public String toString() {
        return this.container.toString(true);
    }
}

