/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.descriptor.impl;

import org.jboss.arquillian.config.descriptor.api.EngineDef;
import org.jboss.arquillian.config.descriptor.impl.ArquillianDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

public class EngineDefImpl
extends ArquillianDescriptorImpl
implements EngineDef {
    private static final String exportPath = "property@name=deploymentExportPath";
    private static final String exportExploded = "property@name=deploymentExportExploded";
    private static final String maxTestClasses = "property@name=maxTestClassesBeforeRestart";
    private Node engine;

    public EngineDefImpl(String descriptorName, Node model, Node engine) {
        super(descriptorName, model);
        this.engine = engine;
    }

    public EngineDef deploymentExportPath(String path) {
        this.engine.getOrCreate(exportPath).text(path);
        return this;
    }

    public String getDeploymentExportPath() {
        return this.getTextIfExists(exportPath);
    }

    public EngineDef deploymentExportExploded(Boolean exploded) {
        this.engine.getOrCreate(exportExploded).text((Object)exploded);
        return this;
    }

    public Boolean getDeploymentExportExploded() {
        return this.getTextIfExistsAsBoolean(exportExploded, false);
    }

    public EngineDef maxTestClassesBeforeRestart(Integer max) {
        this.engine.getOrCreate(maxTestClasses).text((Object)max);
        return this;
    }

    public Integer getMaxTestClassesBeforeRestart() {
        return this.getTextIfExistsAsInteger(maxTestClasses);
    }

    private Integer getTextIfExistsAsInteger(String pattern) {
        String text = this.getTextIfExists(pattern);
        if (text != null) {
            return Integer.parseInt(text);
        }
        return null;
    }

    private Boolean getTextIfExistsAsBoolean(String pattern, Boolean defaultValue) {
        String text = this.getTextIfExists(pattern);
        if (text != null) {
            return Boolean.parseBoolean(text);
        }
        return defaultValue;
    }

    private String getTextIfExists(String pattern) {
        Node propery = this.engine.getSingle(pattern);
        if (propery != null) {
            return propery.getText();
        }
        return null;
    }

    public String toString() {
        return this.engine.toString(true);
    }
}

