/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.DeploymentConfiguration;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.container.test.impl.client.deployment.AbstractDeploymentScenarioGenerator;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class AnnotationDeploymentScenarioGenerator
extends AbstractDeploymentScenarioGenerator
implements DeploymentScenarioGenerator {
    @Override
    protected List<DeploymentConfiguration> generateDeploymentContent(TestClass testClass) {
        Method[] deploymentMethods;
        ArrayList<DeploymentConfiguration> deployments = new ArrayList<DeploymentConfiguration>();
        for (Method deploymentMethod : deploymentMethods = testClass.getMethods(Deployment.class)) {
            this.validate(deploymentMethod);
            deployments.add(this.generateDeploymentContent(deploymentMethod));
        }
        return deployments;
    }

    private void validate(Method deploymentMethod) {
        if (!Modifier.isStatic(deploymentMethod.getModifiers())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " is not static. " + deploymentMethod);
        }
        if (!Archive.class.isAssignableFrom(deploymentMethod.getReturnType()) && !Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " must have return type " + Archive.class.getName() + " or " + Descriptor.class.getName() + ". " + deploymentMethod);
        }
        if (deploymentMethod.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " can not accept parameters. " + deploymentMethod);
        }
    }

    private DeploymentConfiguration generateDeploymentContent(Method deploymentMethod) {
        Deployment deploymentAnnotation = deploymentMethod.getAnnotation(Deployment.class);
        DeploymentConfiguration.DeploymentContentBuilder deploymentContentBuilder = null;
        if (Archive.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            deploymentContentBuilder = new DeploymentConfiguration.DeploymentContentBuilder(this.invoke(Archive.class, deploymentMethod));
        } else if (Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            deploymentContentBuilder = new DeploymentConfiguration.DeploymentContentBuilder(this.invoke(Descriptor.class, deploymentMethod));
        }
        if (deploymentMethod.isAnnotationPresent(OverProtocol.class)) {
            deploymentContentBuilder.withOverProtocol(deploymentMethod.getAnnotation(OverProtocol.class).value());
        }
        if (deploymentMethod.isAnnotationPresent(TargetsContainer.class)) {
            deploymentContentBuilder.withTargetsContainer(deploymentMethod.getAnnotation(TargetsContainer.class).value());
        }
        if (deploymentMethod.isAnnotationPresent(ShouldThrowException.class)) {
            ShouldThrowException shouldThrowException = deploymentMethod.getAnnotation(ShouldThrowException.class);
            deploymentContentBuilder.withShouldThrowException(shouldThrowException.value(), shouldThrowException.testable());
        }
        deploymentContentBuilder = deploymentContentBuilder.withDeployment().withManaged(deploymentAnnotation.managed()).withName(deploymentAnnotation.name()).withOrder(deploymentAnnotation.order()).withTestable(deploymentAnnotation.testable()).build();
        return deploymentContentBuilder.get();
    }

    private <T> T invoke(Class<T> type, Method deploymentMethod) {
        try {
            return type.cast(deploymentMethod.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke deployment method: " + deploymentMethod, e);
        }
    }
}

