/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdefinition;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ValidationException;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdefinition.Length;

public class DummyLengthValidator
implements ConstraintValidator<Length, CharSequence> {
    private int min;
    private int max;

    public void initialize(Length parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
        this.validateParameters();
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        int length = value.length();
        return length >= this.min && length <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw new ValidationException("The min parameter cannot be negative.");
        }
        if (this.max < 0) {
            throw new ValidationException("The max paramter cannot be negative.");
        }
        if (this.max < this.min) {
            throw new ValidationException("The length cannot be negative.");
        }
    }
}

