/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldHaveValue;
import org.assertj.core.internal.Booleans;
import org.assertj.core.util.VisibleForTesting;

public class AtomicBooleanAssert
extends AbstractAssert<AtomicBooleanAssert, AtomicBoolean> {
    @VisibleForTesting
    Booleans booleans = Booleans.instance();

    public AtomicBooleanAssert(AtomicBoolean actual) {
        super(actual, AtomicBooleanAssert.class);
    }

    public AtomicBooleanAssert isTrue() {
        this.isNotNull();
        this.assertEqual(true);
        return (AtomicBooleanAssert)this.myself;
    }

    public AtomicBooleanAssert isFalse() {
        this.isNotNull();
        this.assertEqual(false);
        return (AtomicBooleanAssert)this.myself;
    }

    @Override
    @Deprecated
    public AtomicBooleanAssert usingComparator(Comparator<? super AtomicBoolean> customComparator) {
        throw new UnsupportedOperationException("custom Comparator is not supported for AtomicBoolean comparison");
    }

    private void assertEqual(boolean expected) {
        if (!this.objects.getComparisonStrategy().areEqual(((AtomicBoolean)this.actual).get(), expected)) {
            this.throwAssertionError(ShouldHaveValue.shouldHaveValue(this.actual, expected));
        }
    }
}

